/*
 * PWM.c
 *
 *  Created on: Jun 2, 2016
 *      Author: B42964
 */

#include "derivative.h" /* include peripheral declarations */
#include "PWM.h"
#include "CLOCK.h"

unsigned int gpwm_per;

void PWM1_INIT_CHANNEL(unsigned int pwm_channel_num, unsigned int pwm_per){
	
	PWM1CTL = 0;			// Select 8 bit (CONxx=0) or 16 bit (CONxx=1) operation.
	PWM1CLK = 0;			// Select the clock source (PWMCLK register).
	PWM1PRCLK = 0x44;		// Pre-scaler Select for Clock A-B, CLKPWM = BUS_CLK/16 = 16Mhz/16 = 1MHz
	PWM1POL = 1; 			// Select the PWM polarity (PWMPOL).
	PWM1CAE = 0x00; 		// Select left aligned (CAEx=0) or center aligned (CAEx=1) output.
	gpwm_per = pwm_per;
	
	switch (pwm_channel_num){
		case 1 :
			PWM1PER1 = pwm_per;
			break;
		case 3 :
			PWM1PER3 = pwm_per;
			break;
		case 5 :
			PWM1PER5 = pwm_per;
			break;
	}


}


void PWM1_CTRL_CHANNEL(unsigned int pwm_channel_num, unsigned int pwm_dty, unsigned int pwm_channel_status){
	unsigned int dt;
	dt = (pwm_dty*gpwm_per)/100;
	switch (pwm_channel_num){
		case 1 :
			PWM1DTY1 = dt;								// Pulse width channel 0 is defined
		    PWM1E_PWME1 = pwm_channel_status;		// Pulse width channel 0 is enabled/disabled
			break;
		case 3 :
			PWM1DTY3 = dt;								// Pulse width channel 1 is defined
		    PWM1E_PWME3 = pwm_channel_status;		// Pulse width channel 1 is enabled/disabled
			break;
		case 5 :
			PWM1DTY5 = dt;								// Pulse width channel 2 is defined
		    PWM1E_PWME5 = pwm_channel_status;		// Pulse width channel 2 is enabled/disabled
			break;
	
	}	
	

}

