/* ###################################################################
**     Filename    : main.c
**     Project     : DEVKIT-S12ZVL_Lab2ADC
**     Processor   : MC9S12ZVL32MLF
**     Version     : Driver 01.14
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-05-09, 10:02, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.14
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */

/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "PWM5.h"
#include "AD1.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

unsigned char ADC_status = 0;
word ADC_result[1];
uint16_t adc_value;

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  /* For example: for(;;) { } */

  //AD1_Start();
  for(;;) {
	  AD1_Measure(TRUE);
	  AD1_GetValue16(ADC_result);
	  adc_value = *ADC_result;
	
	  if(1){
	  
		  if(adc_value <= 300){
			  PWMDTY1 = 0x7F;
			  PWMDTY3 = 0;
			  PWMDTY5 = 0;
		  }else if((adc_value > 301) && (adc_value <= 600)){
		      PWMDTY3 = 0x7F;
		      PWMDTY1 =  0;
		      PWMDTY5 =  0;
		  }else if(adc_value > 601){
		      PWMDTY5 = 0x7F;
		      PWMDTY3 = 0;
		      PWMDTY1 = 0; 
		    } 
	  }
  }
  
  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
