/* ###################################################################
**     Filename    : main.c
**     Project     : DEVKIT_S12ZVL_Lab4SCI
**     Processor   : MC9S12ZVL32MLF
**     Version     : Driver 01.14
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-05-09, 15:01, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.14
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */

/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SCI0.h"
#include "LED_RED_PP1.h"
#include "LED_GREEN_PP3.h"
#include "SWITCH_PP4.h"
#include "SWITCH_PP7.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

//--------------------------------------------------------------------------------------------------
//                 Definitions Section
//--------------------------------------------------------------------------------------------------
 
#define LED_GREEN     PTP_PTP1 
#define LED_RED       PTP_PTP3 

#define SW2           PTP_PTP4
#define SW3           PTP_PTP7
//--------------------------------------------------------------------------------------------------
//                 Function Prototypes Section
//--------------------------------------------------------------------------------------------------
void SCI_Send(char *pSendBuff);
unsigned char SCI_Read(void);
//--------------------------------------------------------------------------------------------------
//                  Global Variables Section
//--------------------------------------------------------------------------------------------------
unsigned char dataR;
char Send_SCI[];
//--------------------------------------------------------------------------------------------------
//                 Code Section
//--------------------------------------------------------------------------------------------------
  



void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
 
  /* Write your code here */
  /* For example: for(;;) { } */
  
  for(;;){

       dataR = SCI_Read();
    
      if(dataR == 0x01){
        
  	      LED_GREEN =  1; /* Turn off  */
  	      LED_RED   =  0; /* Turn on   */
  	      
  	  }else if(dataR == 0x02){
  	    
  	      LED_GREEN =  0; /* Turn on   */
  	      LED_RED   =  1; /* Turn off  */          
  	   }
  	   
  	  if(SW2 == 1){
  	    Send_SCI[0] = 0x01;
  	    SCI_Send(Send_SCI);
      }
    
      if(SW3 == 1){
  	    Send_SCI[0] = 0x02;
  	    SCI_Send(Send_SCI);
      }
  
   
    } 

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/


/*******************************************************************************************************************************
* Name : SCI_Send
* Description : Send the message
* In parameters : pSendBuff
* Out parameters : None
* Return value : void
/********************************************************************************************************************************/
void SCI_Send(char *pSendBuff)
{ 
	int ptr = 0;

	while(pSendBuff[ptr]!='\0'){
	
		SCI0DRL = pSendBuff[ptr];		
		while(!SCI0SR1_TC);
		
		ptr++;
	}
}
/*******************************************************************************************************************************
* Name : SCI_Send
* Description : Read the message
* In parameters : pSendBuff
* Out parameters : None
* Return value : SCI0DRL: New value read
/********************************************************************************************************************************/
unsigned char SCI_Read(void){

	if(SCI0SR1_RDRF){
		return SCI0DRL;
	}
}
 

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
