#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "GPIO.h"
#include "ADC.h"


unsigned int ADC_POT_VALUE=0;


void main(void) {
	CPMUVREGCTL_VREG5VEN = 1;
	ADC_init();

	GPIO_CONFIG(P,1,OUTPUT);		// Configure PP4 as OUTPUT for RGB[GREEN-LED]
	GPIO_CONFIG(P,3,OUTPUT);		// Configure PP4 as OUTPUT for RGB[RED-LED]
	GPIO_CONFIG(P,5,OUTPUT);		// Configure PP4 as OUTPUT for RGB[BLUE-LED]
	
	GPIO_WRITE_VALUE(P,1,1);		// Turn-OFF RGB[GREEN-LED]
	GPIO_WRITE_VALUE(P,3,1);		// Turn-OFF RGB[RED-LED]
	GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[BLUE-LED]
  

  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
    ADC_POT_VALUE = ADC_read(AN(2));
    
    if(ADC_POT_VALUE < 1024 && ADC_POT_VALUE >= 683){
    			GPIO_WRITE_VALUE(P,1,0);		// Turn-OFF RGB[GREEN-LED]
    			GPIO_WRITE_VALUE(P,3,1);		// Turn-OFF RGB[RED-LED]
    			GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[BLUE-LED]
    		}
    if(ADC_POT_VALUE < 683 && ADC_POT_VALUE >= 341){
    			GPIO_WRITE_VALUE(P,1,1);		// Turn-OFF RGB[GREEN-LED]
    			GPIO_WRITE_VALUE(P,3,0);		// Turn-OFF RGB[RED-LED]
    			GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[BLUE-LED]
    		}
    		
    if(ADC_POT_VALUE < 341){
    			GPIO_WRITE_VALUE(P,1,1);		// Turn-OFF RGB[GREEN-LED]
    			GPIO_WRITE_VALUE(P,3,1);		// Turn-OFF RGB[RED-LED]
    			GPIO_WRITE_VALUE(P,5,0);		// Turn-OFF RGB[BLUE-LED]
    		}
    
  } /* loop forever */

}
