#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "GPIO.h"





void main(void) {
	
	GPIO_CONFIG(P,4,INPUT); 		// Configure PP4 as INPUT for SW2
	GPIO_CONFIG(P,7,INPUT);			// Configure PP7 as INPUT for SW3
	PULL_ENABLE(P,4,PULLDOWN);		// Enable PULLDOWN resistor in PP4
	PULL_ENABLE(P,7,PULLDOWN);		// Enable PULLDOWN resistor in PP7

	GPIO_CONFIG(P,1,OUTPUT);		// Configure PP4 as OUTPUT for RGB[GREEN-LED]
	GPIO_CONFIG(P,3,OUTPUT);		// Configure PP4 as OUTPUT for RGB[RED-LED]
	GPIO_CONFIG(P,5,OUTPUT);		// Configure PP4 as OUTPUT for RGB[BLUE-LED]
	
	GPIO_WRITE_VALUE(P,1,1);		// Turn-OFF RGB[GREEN-LED]
	GPIO_WRITE_VALUE(P,3,1);		// Turn-OFF RGB[RED-LED]
	GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[BLUE-LED]
  

  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
    if(GPIO_READ(P,4)==1){GPIO_WRITE_VALUE(P,3,0);}
    if(GPIO_READ(P,4)==0){GPIO_WRITE_VALUE(P,3,1);}
    
  } /* loop forever */

}
