/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : BitIO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 10:54, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_BitIO */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Bit1.h"
#include "Bit2.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "BitIO test");
  TEST1_testComment(&testRec, "Pins GPIOA7_ANA7 and GPIOC5_DACO_XB_IN7 should be interconnected!");
  Cpu_Delay100US(1000);

  TEST1_testComment(&testRec, "Bit1 - input; Bit2 - output, initial level low");
  Bit2_SetDir(TRUE);
  Cpu_Delay100US(10);
  if (Bit1_GetVal())
    TEST1_testFailed(&testRec, "Bit1 read high level");
  else  
    TEST1_testComment(&testRec, "Bit1 read low level");
  
  TEST1_testComment(&testRec, "Bit1 - input; Bit2 - output, level high");
  Bit2_SetVal();
  Cpu_Delay100US(10);
  if (!Bit1_GetVal())
    TEST1_testFailed(&testRec, "Bit1 read low level");
  else  
    TEST1_testComment(&testRec, "Bit1 read high level");
  
  TEST1_testComment(&testRec, "Bit1 - input; Bit2 - output, level low");
  Bit2_ClrVal();
  Cpu_Delay100US(10);
  if (Bit1_GetVal())
    TEST1_testFailed(&testRec, "Bit1 read high level");
  else  
    TEST1_testComment(&testRec, "Bit1 read low level");
  
  TEST1_testComment(&testRec, "Bit1 - output, initial level low; Bit2 - input");
  Bit2_SetDir(FALSE);
  Bit1_SetDir(TRUE);
  Cpu_Delay100US(10);
  if (Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read high level");
  else  
    TEST1_testComment(&testRec, "Bit2 read low level");
  
  TEST1_testComment(&testRec, "Bit1 - output, level high; Bit2 - input");
  Bit1_NegVal();
  Cpu_Delay100US(10);
  if (!Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read low level");
  else  
    TEST1_testComment(&testRec, "Bit2 read high level");
  
  TEST1_testComment(&testRec, "Bit1 - output, low; Bit2 - input");
  Bit1_PutVal(FALSE);
  Cpu_Delay100US(10);
  if (Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read high level");
  else  
    TEST1_testComment(&testRec, "Bit2 read low level");
  
  TEST1_testComment(&testRec, "Bit1 - input, low; Bit2 - input");
  Bit1_SetDir(FALSE);
  TEST1_testComment(&testRec, "Bit1_NegVal(), while Bit1 is set as input");
  Bit1_NegVal();
  TEST1_testComment(&testRec, "Bit1 - output, high; Bit2 - input");
  Bit1_SetDir(TRUE);
  Cpu_Delay100US(10);
  if (!Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read low level");
  else  
    TEST1_testComment(&testRec, "Bit2 read high level");



  TEST1_testEnd(&testRec);

}

/* END demo_BitIO */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
