/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bits1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : BitsIO
**     Version     : Component 02.102, Driver 01.22, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:22, # CodeGen: 10
**     Abstract    :
**         This component "BitsIO" implements a multi-bit input/output.
**         It uses selected pins of one 1-bit to 8-bit port.
**     Settings    :
**         Port name                   : GPIOA_Low
**
**         Bit mask of the port        : 00C0
**         Number of bits/pins         : 2
**         Single bit numbers          : 0 to 1
**         Values range                : 0 to 3
**
**         Initial direction           : Input (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 000H
**         Initial pull option         : off
**
**         Port data register          : GPIOA_DR  [E201]
**         Port control register       : GPIOA_DDR [E202]
**         Port function register      : GPIOA_PER [E203]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    19   |   GPIOA6/ANA6/ANC10
**                    1      |    17   |   GPIOA7/ANA7/ANC11
**             ----------------------------------------------------
**
**         Optimization for            : speed
**     Contents    :
**         GetDir - bool Bits1_GetDir(void);
**         SetDir - void Bits1_SetDir(bool Dir);
**         GetVal - byte Bits1_GetVal(void);
**         PutVal - void Bits1_PutVal(byte Val);
**         GetBit - bool Bits1_GetBit(byte Bit);
**         PutBit - void Bits1_PutBit(byte Bit, bool Val);
**         SetBit - void Bits1_SetBit(byte Bit);
**         ClrBit - void Bits1_ClrBit(byte Bit);
**         NegBit - void Bits1_NegBit(byte Bit);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Bits1. */

#include "Bits1.h"

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


static const byte Bits1_Table[2]={ 
0x40U,0x80U};                                     /* Table of mask constants */
/*
** ===================================================================
**     Method      :  Bits1_GetMsk (component BitsIO)
**
**     Description :
**         Returns pin mask. The method is called automatically as a part 
**         of bit method.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static byte Bits1_GetMsk(byte Value)
{
  return((byte)((Value<0x02U)?Bits1_Table[Value]:0x00U)); /* Return appropriate bit mask */
}

/*
** ===================================================================
**     Method      :  Bits1_GetVal (component BitsIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 3)
** ===================================================================
*/
/*
byte Bits1_GetVal(void)

**  This method is implemented as a macro. See Bits1.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bits1_PutVal (component BitsIO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 3)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_PutVal(byte Val)
{
  register word Temp;                  /* Temporary variable */

  Temp = (((word)Val)<<6U) & Bits1_PIN_MASK; /* Prepare value for output */
  Shadow_GPIOA_DR = (Shadow_GPIOA_DR & (word)~(word)Bits1_PIN_MASK) | Temp; /* Set-up bits in shadow variable */
  setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bits1_PIN_MASK) | Temp); /* Set-up bits on port */
}

/*
** ===================================================================
**     Method      :  Bits1_GetBit (component BitsIO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 1)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Bits1_GetBit(byte Bit)
{
  register byte Mask=Bits1_GetMsk(Bit); /* Temporary variable - bit mask */

  return((bool)((Mask)?((((getReg(GPIOA_DR)) & Mask) == Mask)?TRUE:FALSE):0x00U)); /* Return input value */
}

/*
** ===================================================================
**     Method      :  Bits1_PutBit (component BitsIO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 1)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_PutBit(byte Bit, bool Val)
{
  register byte Mask=Bits1_GetMsk(Bit); /* Temporary variable - bit mask */

  if (Mask) {                          /* Is bit mask correct? */
    if (Val) {                         /* Is it one to be written? */
      Shadow_GPIOA_DR |= Mask;         /* Set appropriate bit in shadow variable */
      setRegBits(GPIOA_DR,Mask);       /* Set appropriate bit on port */
    }
    else {                             /* Is it zero to be written? */
      Shadow_GPIOA_DR &= (word)~(word)Mask; /* Clear appropriate bit in shadow variable */
      clrRegBits(GPIOA_DR,Mask);       /* Clear appropriate bit on port */
    }
  }
}

/*
** ===================================================================
**     Method      :  Bits1_SetBit (component BitsIO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 1)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_SetBit(byte Bit)
{
  register byte Mask=Bits1_GetMsk(Bit); /* Temporary variable - bit mask */

  if (Mask) {                          /* Is bit mask correct? */
    Shadow_GPIOA_DR |= Mask;           /* Set appropriate bit in shadow variable */
    setRegBits(GPIOA_DR,Mask);         /* Set appropriate bit on port */
  }
}

/*
** ===================================================================
**     Method      :  Bits1_ClrBit (component BitsIO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 1)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_ClrBit(byte Bit)
{
  register byte Mask=Bits1_GetMsk(Bit); /* Temporary variable - bit mask */

  if (Mask) {                          /* Is bit mask correct? */
    Shadow_GPIOA_DR &= (word)~(word)Mask; /* Clear appropriate bit in shadow variable */
    clrRegBits(GPIOA_DR,Mask);         /* Clear appropriate bit on port */
  }
}

/*
** ===================================================================
**     Method      :  Bits1_NegBit (component BitsIO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_NegBit(byte Bit)
{
  register byte Mask=Bits1_GetMsk(Bit); /* Temporary variable - bit mask */

  if (Mask) {                          /* Is bit mask correct? */
    Shadow_GPIOA_DR ^= Mask;           /* Negate appropriate bit in shadow variable */
    changeRegBits(GPIOA_DR,Mask);      /* Negate appropriate bit on port */
  }
}

/*
** ===================================================================
**     Method      :  Bits1_SetDir (component BitsIO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_SetDir(bool Dir)
{
  if (Dir) {                           /* Is given direction output? */
    setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bits1_PIN_MASK)|(Shadow_GPIOA_DR & Bits1_PIN_MASK)); /* Restore correct value of output from shadow variable */
    setRegBits(GPIOA_DDR,Bits1_PIN_MASK); /* Set direction to output */
  }
  else {                               /* Is direction input? */
    clrRegBits(GPIOA_DDR,Bits1_PIN_MASK); /* Set direction to input */
  }
}

/*
** ===================================================================
**     Method      :  Bits1_GetDir (component BitsIO)
**
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
/*
bool Bits1_GetDir(void)

**  This method is implemented as a macro. See Bits1.h file.  **
*/

/* END Bits1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
