/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : BitsIO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 10:58, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_BitsIO */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Bits1.h"
#include "Bit2.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "BitsIO test");
  TEST1_testComment(&testRec, "Pins GPIOA7_ANA7 and GPIOC5_DACO_XB_IN7 should be interconnected!");
  Cpu_Delay100US(1000);

  TEST1_testComment(&testRec, "Bits1 - input; Bit2 - output, initial level low");
  Bit2_SetDir(TRUE);
  Cpu_Delay100US(10);
  if (Bits1_GetBit(1))
    TEST1_testFailed(&testRec, "Bits1 read high level");
  else  
    TEST1_testComment(&testRec, "Bits1 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - input; Bit2 - output, level high");
  Bit2_SetVal();
  Cpu_Delay100US(10);
  if (!Bits1_GetBit(1))
    TEST1_testFailed(&testRec, "Bits1 read low level");
  else  
    TEST1_testComment(&testRec, "Bits1 read high level");
  
  TEST1_testComment(&testRec, "Bits1 - input; Bit2 - output, level low");
  Bit2_ClrVal();
  Cpu_Delay100US(10);
  if (Bits1_GetBit(1))
    TEST1_testFailed(&testRec, "Bits1 read high level");
  else  
    TEST1_testComment(&testRec, "Bits1 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - output, initial level low; Bit2 - input");
  Bit2_SetDir(FALSE);
  Bits1_SetDir(TRUE);
  Cpu_Delay100US(10);
  if (Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read high level");
  else  
    TEST1_testComment(&testRec, "Bit2 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - output, level high; Bit2 - input");
  Bits1_NegBit(1);
  Cpu_Delay100US(10);
  if (!Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read low level");
  else  
    TEST1_testComment(&testRec, "Bit2 read high level");
  
  TEST1_testComment(&testRec, "Bits1 - output, low; Bit2 - input");
  Bits1_PutBit(1,FALSE);
  Cpu_Delay100US(10);
  if (Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read high level");
  else  
    TEST1_testComment(&testRec, "Bit2 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - input, low; Bit2 - input");
  Bits1_SetDir(FALSE);
  TEST1_testComment(&testRec, "Bits1_NegVal(), while Bits1 is set as input");
  Bits1_NegBit(1);
  TEST1_testComment(&testRec, "Bits1 - output, high; Bit2 - input");
  Bits1_SetDir(TRUE);
  Cpu_Delay100US(10);
  if (!Bit2_GetVal())
    TEST1_testFailed(&testRec, "Bit2 read low level");
  else  
    TEST1_testComment(&testRec, "Bit2 read high level");


  TEST1_testEnd(&testRec);

}
/* END demo_BitsIO */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
