#ifndef _LIB_SCI_H
#define _LIB_SCI_H

#include "CPU.h"
#include "MC56F84789.h"
#include "bootloader_cfg.h"

// SCI clock definition
#define QSCI0_CLOCK_HZ	(1*BUS_CLOCK_HZ)
//#define QSCI0_CLOCK_HZ	(2*BUS_CLOCK_HZ)


//extern void TERMIO_Print(int8_t *str);

#define PrintDigit(d)	TERMIO_PrintDigit(d)
#define Print(s)			TERMIO_Print((int8_t*)s)

#define PrintInfo2(s1,s2)	Print((int8_t*)s1);	Print((int8_t*)" : "); Print((int8_t*)s2);Print((int8_t*)"\r\n")

#define PrintErr2(s1,s2)	Print((int8_t*)"Error: "); PrintInfo2(s1,s2)

void sci_putc(char ch);
void TERMIO_PutChar(int8_t send); 

int8_t TERMIO_GetChar(void); 

void TERMIO_Print(int8_t * str );
void TERMIO_PrintDigit(uint16_t number) ;

void TERMIO_Init(uint32_t baudrate);

//externals
extern void fisr_sci_rx_full(void);
#endif