/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bt31.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Byte3IO
**     Version     : Component 02.054, Driver 01.20, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:27, # CodeGen: 13
**     Abstract    :
**         This component "Byte3IO" implements a three-byte input/output.
**         It uses three 8-bit ports.
**     Settings    :
**         This component uses three 8-bit ports. Their data registers need not be at
**         neighbouring addresses.
**
**         1st 8-bit port name (LSB)   : GPIOC_Low
**         2nd 8-bit port name         : GPIOB_Low
**         3rd 8-bit port name (MSB)   : GPIOA_Low
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 000000000H
**         Initial pull option         : off
**
**         1st 8-bit data register     : GPIOC_DR  [E221]
**         2nd 8-bit data register     : GPIOB_DR  [E211]
**         3rd 8-bit data register     : GPIOA_DR  [E201]
**         1st 8-bit control register  : GPIOC_DDR [E222]
**         2nd 8-bit control register  : GPIOB_DDR [E212]
**         3rd 8-bit control register  : GPIOA_DDR [E202]
**         1st 8-bit function register : GPIOC_PER [E223]
**         2nd 8-bit function register : GPIOB_PER [E213]
**         3rd 8-bit function register : GPIOA_PER [E203]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    3    |   GPIOC0/EXTAL/CLKIN0
**                    1      |    4    |   GPIOC1/XTAL
**                    2      |    5    |   GPIOC2/TXD0/TB0/XB_IN2/CLKO0
**                    3      |    11   |   GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**                    4      |    12   |   GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**                    5      |    27   |   GPIOC5/DACO/XB_IN7
**                    6      |    49   |   GPIOC6/TA2/XB_IN3/CMP_REF
**                    7      |    50   |   GPIOC7/SS0_B/TXD0
**                    8      |    33   |   GPIOB0/ANB0/CMPB_IN3
**                    9      |    34   |   GPIOB1/ANB1/CMPB_IN0
**                    10     |    36   |   GPIOB2/ANB2/CMPC_IN3
**                    11     |    42   |   GPIOB3/ANB3/VREFLB/CMPC_IN0
**                    12     |    30   |   GPIOB4/ANB4/ANC12/CMPC_IN1
**                    13     |    29   |   GPIOB5/ANB5/ANC13/CMPC_IN2
**                    14     |    28   |   GPIOB6/ANB6/ANC14/CMPB_IN1
**                    15     |    26   |   GPIOB7/ANB7/ANC15/CMPB_IN2
**                    16     |    22   |   GPIOA0/ANA0/CMPA_IN3/CMPC_O
**                    17     |    23   |   GPIOA1/ANA1/CMPA_IN0
**                    18     |    24   |   GPIOA2/ANA2/VREFHA/CMPA_IN1
**                    19     |    25   |   GPIOA3/ANA3/VREFLA/CMPA_IN2
**                    20     |    21   |   GPIOA4/ANA4/ANC8/CMPD_IN0
**                    21     |    20   |   GPIOA5/ANA5/ANC9
**                    22     |    19   |   GPIOA6/ANA6/ANC10
**                    23     |    17   |   GPIOA7/ANA7/ANC11
**             ----------------------------------------------------
**     Contents    :
**         GetDir    - bool Bt31_GetDir(void);
**         SetDir    - void Bt31_SetDir(bool Dir);
**         SetInput  - void Bt31_SetInput(void);
**         SetOutput - void Bt31_SetOutput(void);
**         GetVal    - dword Bt31_GetVal(void);
**         PutVal    - void Bt31_PutVal(dword Val);
**         GetBit    - bool Bt31_GetBit(byte Bit);
**         PutBit    - void Bt31_PutBit(byte Bit, bool Val);
**         SetBit    - void Bt31_SetBit(byte Bit);
**         ClrBit    - void Bt31_ClrBit(byte Bit);
**         NegBit    - void Bt31_NegBit(byte Bit);
**         GetRawVal - dword Bt31_GetRawVal(void);
**         GetRawBit - bool Bt31_GetRawBit(byte Bit);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Bt31. */

#include "Bt31.h"
/*Including shared modules, which are used for all project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


/*
** ===================================================================
**     Method      :  Bt31_GetMsk (component Byte3IO)
**
**     Description :
**         Returns pin mask. The method is called automatically as a part 
**         of bit method.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
/* Table of mask constants */
static dword Bt31_Table[24]={
  0x01U, 0x02U, 0x04U, 0x08U, 0x10U, 0x20U, 0x40U, 0x80U,
  0x0100U, 0x0200U, 0x0400U, 0x0800U, 0x1000U, 0x2000U, 0x4000U, 0x8000U,
  0x00010000U, 0x00020000U, 0x00040000U, 0x00080000U, 0x00100000U, 0x00200000U, 0x00400000U, 0x00800000U
};

static dword Bt31_GetMsk(byte Value)
{
  return((dword)((Value<0x18U)?Bt31_Table[Value]:0U)); /* Return appropriate bit mask */
}

/*
** ===================================================================
**     Method      :  Bt31_GetVal (component Byte3IO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 2^24-1)
** ===================================================================
*/
/*
dword Bt31_GetVal(void)

**  This method is implemented as a macro. See Bt31.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bt31_PutVal (component Byte3IO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 2^24-1)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_PutVal(dword Val)
{
  register word Temp;                  /* Temporary variable */
  register word Temp1;                 /* Temporary variable */
  register word Temp2;                 /* Temporary variable */
  Temp = (word)Val & Bt31_LOW_PORT_MASK; /* Prepare value for output */
  Temp1 = ((word)Val >> 8) & Bt31_MIDDLE_PORT_MASK; /* Prepare value for output */
  Temp2 = (word)(Val >> 16) & Bt31_HIGH_PORT_MASK; /* Prepare value for output */
  Shadow_GPIOC_DR = (Shadow_GPIOC_DR & (word)~(word)Bt31_LOW_PORT_MASK) | Temp; /* Set-up shadow variable */
  Shadow_GPIOB_DR = (Shadow_GPIOB_DR & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1; /* Set-up shadow variable */
  Shadow_GPIOA_DR = (Shadow_GPIOA_DR & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2; /* Set-up shadow variable */
  setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK) | Temp); /* Set-up low port */
  setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1); /* Set-up mid. port */
  setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2); /* Set-up high port */
}

/*
** ===================================================================
**     Method      :  Bt31_GetBit (component Byte3IO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 23)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Bt31_GetBit(byte Bit)
{
  register dword Mask=Bt31_GetMsk(Bit); /* Temporary variable - bit mask */
  register dword Value;                /* Temporary variable */
  register bool Result=FALSE;          /* Temporary variable */

  if (Mask) {                          /* Is bit mask correct? */
    Value = ((dword)((getReg(GPIOA_DR)) & Bt31_HIGH_PORT_MASK) << 16); /* Load of actual value of the port */
    Value |= ((dword)((getReg(GPIOB_DR)) & Bt31_MIDDLE_PORT_MASK) << 8);
    Value |= (dword)((getReg(GPIOC_DR)) & Bt31_LOW_PORT_MASK);
    Value &= Mask;                     /* Mask appropriate bit */
    Result = (bool)((Value == Mask)?TRUE:FALSE); /* If value of masked bit is non-zero then store logical one to the variable Result */
  }
  return(Result);                      /* Return input value */
}

/*
** ===================================================================
**     Method      :  Bt31_PutBit (component Byte3IO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 23)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_PutBit(byte Bit, bool Val)
{
  register dword Mask=Bt31_GetMsk(Bit); /* Temporary variable - bit mask */
  register dword Value;                /* Temporary variable */
  register word Temp;                  /* Temporary variable */
  register word Temp1;                 /* Temporary variable */
  register word Temp2;                 /* Temporary variable */
  
  if (Mask) {                          /* Is bit mask correct? */
    Value = ((dword)(Shadow_GPIOA_DR & Bt31_HIGH_PORT_MASK) << 16) | ((dword)(Shadow_GPIOB_DR & Bt31_MIDDLE_PORT_MASK) << 8) | (dword)(Shadow_GPIOC_DR & Bt31_LOW_PORT_MASK); /* Load of actual value of the port */
    if (Val) {                         /* Is it one to be written? */
      Value |= Mask;                   /* Set appropriate bit */
    }
    else {                             /* Is it zero to be written? */
      Value &= ~Mask;                  /* Clear appropriate bit */
    }
    Temp = (word)Value & Bt31_LOW_PORT_MASK; /* Prepare value for output */
    Temp1 = ((word)Value >> 8) & Bt31_MIDDLE_PORT_MASK; /* Prepare value for output */
    Temp2 = (word)(Value >> 16) & Bt31_HIGH_PORT_MASK; /* Prepare value for output */
    Shadow_GPIOC_DR = (Shadow_GPIOC_DR & (word)~(word)Bt31_LOW_PORT_MASK) | Temp; /* Set-up shadow variable */
    Shadow_GPIOB_DR = (Shadow_GPIOB_DR & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1; /* Set-up shadow variable */
    Shadow_GPIOA_DR = (Shadow_GPIOA_DR & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2; /* Set-up shadow variable */
    setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK) | Temp); /* Set-up low port */
    setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1); /* Set-up mid. port */
    setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2); /* Set-up high port */
  }
}

/*
** ===================================================================
**     Method      :  Bt31_SetBit (component Byte3IO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 23)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_SetBit(byte Bit)
{
  register dword Mask=Bt31_GetMsk(Bit); /* Temporary variable - bit mask */
  register dword Value;                /* Temporary variable */
  register word Temp;                  /* Temporary variable */
  register word Temp1;                 /* Temporary variable */
  register word Temp2;                 /* Temporary variable */
  
  if (Mask) {                          /* Is bit mask correct? */
    Value = ((dword)(Shadow_GPIOA_DR & Bt31_HIGH_PORT_MASK) << 16) | ((dword)(Shadow_GPIOB_DR & Bt31_MIDDLE_PORT_MASK) << 8) | (dword)(Shadow_GPIOC_DR & Bt31_LOW_PORT_MASK); /* Load of actual value of the port */
    Value |= Mask;                     /* Set appropriate bit */
    Temp = (word)Value & Bt31_LOW_PORT_MASK; /* Prepare value for output */
    Temp1 = ((word)Value >> 8) & Bt31_MIDDLE_PORT_MASK; /* Prepare value for output */
    Temp2 = (word)(Value >> 16) & Bt31_HIGH_PORT_MASK; /* Prepare value for output */
    Shadow_GPIOC_DR = (Shadow_GPIOC_DR & (word)~(word)Bt31_LOW_PORT_MASK) | Temp; /* Set-up shadow variable */
    Shadow_GPIOB_DR = (Shadow_GPIOB_DR & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1; /* Set-up shadow variable */
    Shadow_GPIOA_DR = (Shadow_GPIOA_DR & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2; /* Set-up shadow variable */
    setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK) | Temp); /* Set-up low port */
    setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1); /* Set-up mid. port */
    setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2); /* Set-up high port */
  }
}

/*
** ===================================================================
**     Method      :  Bt31_ClrBit (component Byte3IO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 23)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_ClrBit(byte Bit)
{
  register dword Mask=Bt31_GetMsk(Bit); /* Temporary variable - bit mask */
  register dword Value;                /* Temporary variable */
  register word Temp;                  /* Temporary variable */
  register word Temp1;                 /* Temporary variable */
  register word Temp2;                 /* Temporary variable */
  
  if (Mask) {                          /* Is bit mask correct? */
    Value = ((dword)(Shadow_GPIOA_DR & Bt31_HIGH_PORT_MASK) << 16) | ((dword)(Shadow_GPIOB_DR & Bt31_MIDDLE_PORT_MASK) << 8) | (dword)(Shadow_GPIOC_DR & Bt31_LOW_PORT_MASK); /* Load of actual value of the port */
    Value &= ~Mask;                    /* Clear appropriate bit */
    Temp = (word)Value & Bt31_LOW_PORT_MASK; /* Prepare value for output */
    Temp1 = ((word)Value >> 8) & Bt31_MIDDLE_PORT_MASK; /* Prepare value for output */
    Temp2 = (word)(Value >> 16) & Bt31_HIGH_PORT_MASK; /* Prepare value for output */
    Shadow_GPIOC_DR = (Shadow_GPIOC_DR & (word)~(word)Bt31_LOW_PORT_MASK) | Temp; /* Set-up shadow variable */
    Shadow_GPIOB_DR = (Shadow_GPIOB_DR & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1; /* Set-up shadow variable */
    Shadow_GPIOA_DR = (Shadow_GPIOA_DR & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2; /* Set-up shadow variable */
    setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK) | Temp); /* Set-up low port */
    setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1); /* Set-up mid. port */
    setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2); /* Set-up high port */
  }
}

/*
** ===================================================================
**     Method      :  Bt31_NegBit (component Byte3IO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 23)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_NegBit(byte Bit)
{
  register dword Mask=Bt31_GetMsk(Bit); /* Temporary variable - bit mask */
  register dword Value;                /* Temporary variable */
  register word Temp;                  /* Temporary variable */
  register word Temp1;                 /* Temporary variable */
  register word Temp2;                 /* Temporary variable */
  
  if (Mask) {                          /* Is bit mask correct? */
    Value = ((dword)(Shadow_GPIOA_DR & Bt31_HIGH_PORT_MASK) << 16) | ((dword)(Shadow_GPIOB_DR & Bt31_MIDDLE_PORT_MASK) << 8) | (dword)(Shadow_GPIOC_DR & Bt31_LOW_PORT_MASK); /* Load of actual value of the port */
    Value ^= Mask;                     /* Negate appropriate bit */
    Temp = (word)Value & Bt31_LOW_PORT_MASK; /* Prepare value for output */
    Temp1 = ((word)Value >> 8) & Bt31_MIDDLE_PORT_MASK; /* Prepare value for output */
    Temp2 = (word)(Value >> 16) & Bt31_HIGH_PORT_MASK; /* Prepare value for output */
    Shadow_GPIOC_DR = (Shadow_GPIOC_DR & (word)~(word)Bt31_LOW_PORT_MASK) | Temp; /* Set-up shadow variable */
    Shadow_GPIOB_DR = (Shadow_GPIOB_DR & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1; /* Set-up shadow variable */
    Shadow_GPIOA_DR = (Shadow_GPIOA_DR & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2; /* Set-up shadow variable */
    setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK) | Temp); /* Set-up low port */
    setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK) | Temp1); /* Set-up mid. port */
    setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK) | Temp2); /* Set-up high port */
  }
}

/*
** ===================================================================
**     Method      :  Bt31_SetDir (component Byte3IO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_SetDir(bool Dir)
{
  if (Dir) {                           /* Is given direction output? */
    setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK)|(Shadow_GPIOC_DR & Bt31_LOW_PORT_MASK)); /* Restore correct value of output from shadow variable */
    setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK)|(Shadow_GPIOB_DR & Bt31_MIDDLE_PORT_MASK)); /* Restore correct value of output from shadow variable */
    setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK)|(Shadow_GPIOA_DR & Bt31_HIGH_PORT_MASK)); /* Restore correct value of output from shadow variable */
    setRegBits(GPIOC_DDR,Bt31_LOW_PORT_MASK); /* Set direction to output */
    setRegBits(GPIOB_DDR,Bt31_MIDDLE_PORT_MASK); /* Set direction to output */
    setRegBits(GPIOA_DDR,Bt31_HIGH_PORT_MASK); /* Set direction to output */
  }
  else {                               /* Is direction input? */
    clrRegBits(GPIOC_DDR,Bt31_LOW_PORT_MASK); /* Set direction to input */
    clrRegBits(GPIOB_DDR,Bt31_MIDDLE_PORT_MASK); /* Set direction to input */
    clrRegBits(GPIOA_DDR,Bt31_HIGH_PORT_MASK); /* Set direction to input */
  }
}

/*
** ===================================================================
**     Method      :  Bt31_SetInput (component Byte3IO)
**
**     Description :
**         This method sets direction of the component to input.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Bt31_SetInput(void)

**  This method is implemented as a macro. See Bt31.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bt31_SetOutput (component Byte3IO)
**
**     Description :
**         This method sets direction of the component to output.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_SetOutput(void)
{
  setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bt31_LOW_PORT_MASK)|(Shadow_GPIOC_DR & Bt31_LOW_PORT_MASK)); /* Restore correct value of output from shadow variable */
  setReg(GPIOB_DR,((getReg(GPIOB_DR)) & (word)~(word)Bt31_MIDDLE_PORT_MASK)|(Shadow_GPIOB_DR & Bt31_MIDDLE_PORT_MASK)); /* Restore correct value of output from shadow variable */
  setReg(GPIOA_DR,((getReg(GPIOA_DR)) & (word)~(word)Bt31_HIGH_PORT_MASK)|(Shadow_GPIOA_DR & Bt31_HIGH_PORT_MASK)); /* Restore correct value of output from shadow variable */
  setRegBits(GPIOC_DDR,Bt31_LOW_PORT_MASK); /* Set direction to output */
  setRegBits(GPIOB_DDR,Bt31_MIDDLE_PORT_MASK); /* Set direction to output */
  setRegBits(GPIOA_DDR,Bt31_HIGH_PORT_MASK); /* Set direction to output */
}

/*
** ===================================================================
**     Method      :  Bt31_GetDir (component Byte3IO)
**
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
/*
bool Bt31_GetDir(void)

**  This method is implemented as a macro. See Bt31.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bt31_GetRawVal (component Byte3IO)
**
**     Description :
**         Returns the value of the ports. The method uses raw data
**         input register, i.e., a register that always reads back
**         the status of the port regardless of the port direction.
**         The method is available only if raw data input is
**         supported by all selected ports. 
**     Parameters  : None
**     Returns     :
**         ---             - Input value
** ===================================================================
*/
/*
dword Bt31_GetRawVal(void)

**  This method is implemented as a macro. See Bt31.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bt31_GetRawBit (component Byte3IO)
**
**     Description :
**         Returns the value of the specified bit/pin. The method
**         uses raw data input register, i.e., a register that
**         always reads back the status of the port regardless of
**         the port direction. The method is available only if raw
**         data input is supported by all selected ports. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         Bit             - Bit/pin number to read.
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
** ===================================================================
*/
bool Bt31_GetRawBit(byte Bit)
{
  register dword Mask=Bt31_GetMsk(Bit); /* Temporary variable - bit mask */
  register dword Value;                /* Temporary variable */
  register bool Result=FALSE;          /* Temporary variable */

  if (Mask) {                          /* Is bit mask correct? */
    Value = ((dword)((getReg(GPIOA_RAWDATA)) & Bt31_HIGH_PORT_MASK) << 16); /* Load of actual value of the port */
    Value |= ((dword)((getReg(GPIOB_RAWDATA)) & Bt31_MIDDLE_PORT_MASK) << 8);
    Value |= (dword)((getReg(GPIOC_RAWDATA)) & Bt31_LOW_PORT_MASK);
    Value &= Mask;                     /* Mask appropriate bit */
    Result = (bool)((Value == Mask)?TRUE:FALSE); /* If value of masked bit is non-zero then store logical one to the variable Result */
  }
  return(Result);                      /* Return input value */
}

/* END Bt31. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
