/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bt31.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Byte3IO
**     Version     : Component 02.054, Driver 01.20, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:27, # CodeGen: 13
**     Abstract    :
**         This component "Byte3IO" implements a three-byte input/output.
**         It uses three 8-bit ports.
**     Settings    :
**         This component uses three 8-bit ports. Their data registers need not be at
**         neighbouring addresses.
**
**         1st 8-bit port name (LSB)   : GPIOC_Low
**         2nd 8-bit port name         : GPIOB_Low
**         3rd 8-bit port name (MSB)   : GPIOA_Low
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 000000000H
**         Initial pull option         : off
**
**         1st 8-bit data register     : GPIOC_DR  [E221]
**         2nd 8-bit data register     : GPIOB_DR  [E211]
**         3rd 8-bit data register     : GPIOA_DR  [E201]
**         1st 8-bit control register  : GPIOC_DDR [E222]
**         2nd 8-bit control register  : GPIOB_DDR [E212]
**         3rd 8-bit control register  : GPIOA_DDR [E202]
**         1st 8-bit function register : GPIOC_PER [E223]
**         2nd 8-bit function register : GPIOB_PER [E213]
**         3rd 8-bit function register : GPIOA_PER [E203]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    3    |   GPIOC0/EXTAL/CLKIN0
**                    1      |    4    |   GPIOC1/XTAL
**                    2      |    5    |   GPIOC2/TXD0/TB0/XB_IN2/CLKO0
**                    3      |    11   |   GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**                    4      |    12   |   GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**                    5      |    27   |   GPIOC5/DACO/XB_IN7
**                    6      |    49   |   GPIOC6/TA2/XB_IN3/CMP_REF
**                    7      |    50   |   GPIOC7/SS0_B/TXD0
**                    8      |    33   |   GPIOB0/ANB0/CMPB_IN3
**                    9      |    34   |   GPIOB1/ANB1/CMPB_IN0
**                    10     |    36   |   GPIOB2/ANB2/CMPC_IN3
**                    11     |    42   |   GPIOB3/ANB3/VREFLB/CMPC_IN0
**                    12     |    30   |   GPIOB4/ANB4/ANC12/CMPC_IN1
**                    13     |    29   |   GPIOB5/ANB5/ANC13/CMPC_IN2
**                    14     |    28   |   GPIOB6/ANB6/ANC14/CMPB_IN1
**                    15     |    26   |   GPIOB7/ANB7/ANC15/CMPB_IN2
**                    16     |    22   |   GPIOA0/ANA0/CMPA_IN3/CMPC_O
**                    17     |    23   |   GPIOA1/ANA1/CMPA_IN0
**                    18     |    24   |   GPIOA2/ANA2/VREFHA/CMPA_IN1
**                    19     |    25   |   GPIOA3/ANA3/VREFLA/CMPA_IN2
**                    20     |    21   |   GPIOA4/ANA4/ANC8/CMPD_IN0
**                    21     |    20   |   GPIOA5/ANA5/ANC9
**                    22     |    19   |   GPIOA6/ANA6/ANC10
**                    23     |    17   |   GPIOA7/ANA7/ANC11
**             ----------------------------------------------------
**     Contents    :
**         GetDir    - bool Bt31_GetDir(void);
**         SetDir    - void Bt31_SetDir(bool Dir);
**         SetInput  - void Bt31_SetInput(void);
**         SetOutput - void Bt31_SetOutput(void);
**         GetVal    - dword Bt31_GetVal(void);
**         PutVal    - void Bt31_PutVal(dword Val);
**         GetBit    - bool Bt31_GetBit(byte Bit);
**         PutBit    - void Bt31_PutBit(byte Bit, bool Val);
**         SetBit    - void Bt31_SetBit(byte Bit);
**         ClrBit    - void Bt31_ClrBit(byte Bit);
**         NegBit    - void Bt31_NegBit(byte Bit);
**         GetRawVal - dword Bt31_GetRawVal(void);
**         GetRawBit - bool Bt31_GetRawBit(byte Bit);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __Bt31_H
#define __Bt31_H

/* MODULE Bt31. */

/*Including shared modules, which are used in the whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


#define Bt31_LOW_PORT_MASK      ((byte)0xFF) /* Low port mask */
#define Bt31_MIDDLE_PORT_MASK   ((byte)0xFF) /* Middle port mask */
#define Bt31_HIGH_PORT_MASK     ((byte)0xFF) /* High port mask */

/*
** ===================================================================
**     Method      :  Bt31_GetVal (component Byte3IO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 2^24-1)
** ===================================================================
*/
#define Bt31_GetVal() ( \
/*lint -save  -e740 -e931 Disable MISRA rule (1.2) checking. Order of register access is not important for IO access. */\
  ((dword)((getReg(GPIOA_DR)) & Bt31_HIGH_PORT_MASK) << 16) | ((dword)((getReg(GPIOB_DR)) & Bt31_MIDDLE_PORT_MASK) << 8) | (dword)((getReg(GPIOC_DR)) & Bt31_LOW_PORT_MASK) \
/*lint -restore Enable MISRA rule (1.2) checking. */\
)

/*
** ===================================================================
**     Method      :  Bt31_PutVal (component Byte3IO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 2^24-1)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_PutVal(dword Val);

/*
** ===================================================================
**     Method      :  Bt31_GetBit (component Byte3IO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 23)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Bt31_GetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt31_PutBit (component Byte3IO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 23)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_PutBit(byte Bit, bool Val);

/*
** ===================================================================
**     Method      :  Bt31_SetBit (component Byte3IO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 23)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_SetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt31_ClrBit (component Byte3IO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 23)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_ClrBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt31_NegBit (component Byte3IO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 23)
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_NegBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt31_SetDir (component Byte3IO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_SetDir(bool Val);

/*
** ===================================================================
**     Method      :  Bt31_SetInput (component Byte3IO)
**
**     Description :
**         This method sets direction of the component to input.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Bt31_SetInput()\
/*lint -save  -e505 -e522 -e961 Disable MISRA rule (14.2,12.1) checking. Order of register access is not important for IO access. */\
( \
  clrRegBits(GPIOC_DDR,Bt31_LOW_PORT_MASK), /* Set direction to input */ \
  clrRegBits(GPIOB_DDR,Bt31_MIDDLE_PORT_MASK), /* Set direction to input */ \
  clrRegBits(GPIOA_DDR,Bt31_HIGH_PORT_MASK), /* Set direction to input */ \
  (void)0 \
) 
/*lint -restore Enable MISRA rule (14.2,12.1) checking. */

/*
** ===================================================================
**     Method      :  Bt31_SetOutput (component Byte3IO)
**
**     Description :
**         This method sets direction of the component to output.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bt31_SetOutput(void);

/*
** ===================================================================
**     Method      :  Bt31_GetDir (component Byte3IO)
**
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
#define Bt31_GetDir() ((bool)(getRegBits(GPIOC_DDR,0xFF)))

/*
** ===================================================================
**     Method      :  Bt31_GetRawVal (component Byte3IO)
**
**     Description :
**         Returns the value of the ports. The method uses raw data
**         input register, i.e., a register that always reads back
**         the status of the port regardless of the port direction.
**         The method is available only if raw data input is
**         supported by all selected ports. 
**     Parameters  : None
**     Returns     :
**         ---             - Input value
** ===================================================================
*/
#define Bt31_GetRawVal() ( \
/*lint -save  -e740 -e931 Disable MISRA rule (1.2) checking. Order of register access is not important for IO access. */\
  ((dword)((getReg(GPIOA_RAWDATA)) & Bt31_HIGH_PORT_MASK) << 16) | ((dword)((getReg(GPIOB_RAWDATA)) & Bt31_MIDDLE_PORT_MASK) << 8) | (dword)((getReg(GPIOC_RAWDATA)) & Bt31_LOW_PORT_MASK) \
/*lint -restore Enable MISRA rule (1.2) checking. */\
)

/*
** ===================================================================
**     Method      :  Bt31_GetRawBit (component Byte3IO)
**
**     Description :
**         Returns the value of the specified bit/pin. The method
**         uses raw data input register, i.e., a register that
**         always reads back the status of the port regardless of
**         the port direction. The method is available only if raw
**         data input is supported by all selected ports. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         Bit             - Bit/pin number to read.
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
** ===================================================================
*/
bool Bt31_GetRawBit(byte Bit);

/* END Bt31. */

#endif /* __Bt31_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
