/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ByteIO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 11:42, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_ByteIO */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Byte1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;
  bool Err=FALSE;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "ByteIO test");
  TEST1_testComment(&testRec, "");
  TEST1_testComment(&testRec, "This project tests the basic method of the ByteIO bean.");

  /* Method SetDir, GetDir */
  Byte1_SetDir(FALSE);                                      /* Set direction of the port (INPUT) */
  if(Byte1_GetDir()!=FALSE) {
    TEST1_testFailed(&testRec, "SetDir or GetDir method");
    Err=TRUE;
  } else {
    Byte1_SetDir(TRUE);                                     /* Set direction of the port (OUTPUT) */
    if(Byte1_GetDir()==FALSE) {
      TEST1_testFailed(&testRec, "SetDir or GetDir method");
      Err=TRUE;
    } else {
      TEST1_testComment(&testRec, "SetDir and GetDir method OK");
    }
  }
  /* If Err=FALSE, test will continue. */
  if(Err==FALSE){
    /* Method SetInput */
    Byte1_SetInput();                                       /* Set direction of the port (INPUT) */
    if(Byte1_GetDir()!=FALSE) {
      TEST1_testFailed(&testRec, "SetInput method");
    } else {
      TEST1_testComment(&testRec, "SetInput method OK");
    }
    /* Method SetOutput */
    Byte1_SetOutput();                                      /* Set direction of the port (OUTPUT) */
    if(Byte1_GetDir()==FALSE) {
      TEST1_testFailed(&testRec, "SetOutput method");
    } else {
      TEST1_testComment(&testRec, "SetOutput method OK");
    }
    /* Method PutVal, GetVal, GetRawVal */
    Byte1_PutVal(0xaa);                                   /* Set output to 0xaa */
    if((Byte1_GetVal()!=0xaa) & (Byte1_GetRawVal()!=0xaa)) {
      TEST1_testFailed(&testRec, "PutVal, GetVal or GetRawVal method");
    } else {
      Byte1_PutVal(0x55);                                 /* Set output to 0x55 */
      if((Byte1_GetVal()!=0x55) & (Byte1_GetRawVal()!=0x55)) {
        TEST1_testFailed(&testRec, "PutVal, GetVal or GetRawVal method");
      } else {
        TEST1_testComment(&testRec, "PutVal, GetVal and GetRawVal method OK");
      }
    }
    /* Method GetBit, PutBit, GetRawBit */
    Byte1_PutBit(0, FALSE);                                 /* Set output pin to Low */
    if((Byte1_GetBit(0)!=FALSE) & (Byte1_GetRawBit(0)!=FALSE)){
      TEST1_testFailed(&testRec, "GetBit, PutBit or GetRawBit method");
      Err=TRUE;
    } else {
      Byte1_PutBit(0, TRUE);                                /* Set output pin to High */
      if((Byte1_GetBit(0)==FALSE) & (Byte1_GetRawBit(0)==FALSE)){
        TEST1_testFailed(&testRec, "GetBit, PutBit or GetRawBit method");
        Err=TRUE;
      } else {
        TEST1_testComment(&testRec, "GetBit, PutBit and GetRawBit method OK");
      }
    }
    if(Err==FALSE){
      /* Method SetBit, ClrBit, NegBit */
      Byte1_PutVal(0);                                      /* Set output pins to Low */
      Byte1_SetBit(7);                                     /* Set output pin to High */
      if(Byte1_GetBit(7)==FALSE) {
        TEST1_testFailed(&testRec, "SetBit method");
      } else {
        TEST1_testComment(&testRec, "SetBit method OK");
        Byte1_ClrBit(7);                                   /* Set output pin to Low */
        if(Byte1_GetBit(7)!=FALSE) {
          TEST1_testFailed(&testRec, "ClrBit method");
        } else {
          TEST1_testComment(&testRec, "ClrBit method OK");
          Byte1_NegBit(7);                                 /* Negate output pin to High */
          if(Byte1_GetBit(7)==FALSE) {
            TEST1_testFailed(&testRec, "NegBit method");
          } else {
            TEST1_testComment(&testRec, "NegBit method OK");
          }
        }
      }
    }
  }
  /* Test end */
  TEST1_testEnd(&testRec);
}

/* END demo_ByteIO */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
