/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : CAN
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 15:06, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_CAN */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "CAN1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define CAN_MSG_LEN  8
#define CAN_MSG_ID   1
#define CAN_TX_BUFF  0
#define CAN_RX_BUFF  1

byte LoopTxBuffer[CAN_MSG_LEN];
byte LoopRxBuffer[CAN_MSG_LEN];
byte i, err, frameType, frameFormat, msgLen;
volatile byte OnFreeTxBuffer = 0;
volatile byte OnFullRxBuffer = 0;
dword msgID;
bool cmpFailed;


void main(void)
{
  test_sRec testRec;


  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "FlexCAN test");
  //
  for (i=0;i<CAN_MSG_LEN;i++) {
    LoopTxBuffer[i] = (byte)i;
    LoopRxBuffer[i] = 0xff;
  }
  //
  TEST1_testComment(&testRec, "Transmitting CAN message (ID=1) ...");
  err = CAN1_SendFrame(CAN_TX_BUFF, CAN_MSG_ID, DATA_FRAME, CAN_MSG_LEN, LoopTxBuffer, FALSE);
  //
  while (!CAN1_GetStateRX()) {}
  //
  if (err == ERR_OK)
    TEST1_testComment(&testRec, "PASSED");
  else
    TEST1_testFailed(&testRec, "Transmitting CAN message failed");
  //
  TEST1_testComment(&testRec, "Receiving CAN message ...");
  err = CAN1_ReadFrame(CAN_RX_BUFF, &msgID, &frameType, &frameFormat, &msgLen, LoopRxBuffer);
  if (err != ERR_OK) {
    TEST1_testFailed(&testRec, "Receiving CAN message failed");
  } else  {
    if (msgID != CAN_MSG_ID) {
      TEST1_testFailed(&testRec, "Received message ID is different");
    } else {
      if (msgLen != CAN_MSG_LEN) {
        TEST1_testFailed(&testRec, "Received message length is different");
      } else {
        if (frameType != DATA_FRAME) {
          TEST1_testFailed(&testRec, "Received frame type (DATA/REMOTE) is different");
        } else {
          if (frameFormat != STANDARD_FORMAT) {
            TEST1_testFailed(&testRec, "Received frame format (STANDARD/EXTENDED) is different");
          } else {
            TEST1_testComment(&testRec, "PASSED");
          }
        }
      }
    }
  }
  //
  //
  TEST1_testComment(&testRec, "Comparing received/sent CAN message ...");
  cmpFailed = FALSE;
  for (i=0;i<CAN_MSG_LEN;i++) {
    if ( LoopTxBuffer[i] !=  LoopRxBuffer[i]) {
      cmpFailed = TRUE;
    }
  }
  if (cmpFailed) {
    TEST1_testFailed(&testRec, "Comparing received/sent CAN message failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }
  //
  TEST1_testComment(&testRec, "Testing OnFreeTxBuffer event ...");
  if (OnFreeTxBuffer != 1) {
    TEST1_testFailed(&testRec, "Testing OnFreeTxBuffer event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }
  TEST1_testComment(&testRec, "Testing OnFullRxBuffer event ...");
  if (OnFullRxBuffer != 1) {
    TEST1_testFailed(&testRec, "Testing OnFullRxBuffer event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }
  //
  TEST1_testEnd(&testRec);
  //
}

/* END default */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
