/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: Events.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!*/

#include "Types.h"
#include "Cpu.h"
#include "Events.h"
#include "Main.h"


extern ADC_RESULT	udtADCresults;	
/***************************************************************************//*!
*
* @brief   CPU ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{
  setReg16Bits(INTC_CTRL, 0x20);		/*Disable all interrupts*/
  while(1);// shouldn't reach here 
}

/***************************************************************************//*!
*
* @brief   Timer Compare ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
#pragma interrupt alignsp
void TI1_ISR(void)
{
  clrReg16Bits(TMRA_1_CSCTRL,0x10);    /* Clear interrupt request flag */
  invertReg16Bits(GPIOF_DR,0x040);	/* Toggle GPIOF6 output */
  	
}

/***************************************************************************//*!
*
* @brief   PWMA SM0 reload
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
#pragma interrupt alignsp
void PWMA_0_Reload_ISR(void)
{
	setReg16Bits(PWMA_SM0STS,0x1000);    /* Clear interrupt request flag */
	invertReg16Bits(GPIOE_DR,0x100);	/* Toggle GPIOE9 output */
}

/***************************************************************************//*!
*
* @brief   PDB0 Delay A ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
#pragma interrupt alignsp
void PDB0_ISR(void)
{
  setReg16Bits(PDB0_CTRLA,0x800);    /* Clear interrupt request flag */
  invertReg16Bits(GPIOE_DR,0x100);	/* Toggle GPIOE1 output */	
  	
}

/***************************************************************************//*!
*
* @brief   ADC12 End of Scan ISR Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/

#pragma interrupt alignsp
void ADC12_EOS_ISR(void)
{
	/* read ADC samples from channels 0&8  */	
	udtADCresults.adc_result0 = ADC12_RSLT0;
	udtADCresults.adc_result8 = ADC12_RSLT8;

	setReg16Bits(ADC12_STAT,0x800);    /* Clear interrupt request flag */
	invertReg16Bits(GPIOE_DR,0x0100);	/* Toggle GPIOE8 output */	
  	
}


/* END Events */
