/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: PDB_test.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "PDB_test.h"


/***************************************************************************//*!
*
* @brief   PDB Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PDB_Init(void)
{
	SIM_PCE2 |= SIM_PCE2_PDB0; 		  //enable clock to PDB peripheral
	
	PDB0_MCTRL |= PDB0_MCTRL_PDBEN;  // set HW trigger 0 and enable PDB
	
	PDB0_MOD = PWMA_SM0VAL1<<1;     // set Modulus register to PWM_A modulo value
	
	PDB0_DELAYA = 1;
	PDB0_DELAYB = 1;
	PDB0_DELAYC = 1;
	PDB0_DELAYD = 1;
	
	PDB0_CTRLA = PDB0_CTRLA_ENA | PDB0_CTRLA_DAIE; // enable Delay A interrupt 
	
	PDB0_MCTRL |= PDB0_MCTRL_LDOK;  // load new values into value registers
	
	/* PWMA0 trigger connected to PDB TRIG0 Sync pulse   */
	XBARA_SEL19 = 0x0014U; //trigger signal connected to PWMA0 trigger - XBARA_OUT38 = XBAR_IN20

#if PDB_ISR_ON	
	clrSetReg16Bits(INTC_IPR11, 0xFFFF, 0x0001);	/* Set interrupt priority of PDB0 Delay A as level 0 */
#endif
}


/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/