/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : EC161.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : EventCntr16
**     Version     : Component 02.136, Driver 02.06, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:35, # CodeGen: 10
**     Abstract    :
**         This component "EventCntr16" implements an 16-bit event counter.
**         It counts the external events (specified edges of the external
**         signal). It uses a hardware timer counter.
**         The counter width is extended or taperred to 16 bits.
**     Settings    :
**         Timer name                  : TMRA0 [16-bit]
**
**         Counting mode               : Repetitive
**         User handling procedure     : EC161_OnEnd
**         This event is called when the 10000 of iterations is generated
**
**         Used input pin              : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**
**         Initialization:
**              Timer                  : Disabled
**              Events                 : Enabled
**
**         Timer registers
**         Counter register            : TMRA_0_CNTR [E145]
**         Mode register               : TMRA_0_CTRL [E146]
**         Run register                : TMRA_0_CTRL [E146]
**     Contents    :
**         Enable       - byte EC161_Enable(void);
**         Reset        - byte EC161_Reset(void);
**         GetNumEvents - byte EC161_GetNumEvents(word *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE EC161. */

#include "Events.h"
#include "EC161.h"

/*
** ===================================================================
**     Method      :  EC161_Enable (component EventCntr16)
**
**     Description :
**         This method enables the component - the external events are
**         counted.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/
byte EC161_Enable(void)
{
  setRegBitGroup(TMRA_0_CTRL,CM,1);
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  EC161_Reset (component EventCntr16)
**
**     Description :
**         This method resets the external event counter (sets it to
**         zero).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/
byte EC161_Reset(void)
{
  setReg(TMRA_0_CNTR,0x00);            /* Set counter register */
  return ERR_OK;                       /* Return OK */
}

/*
** ===================================================================
**     Method      :  EC161_GetNumEvents (component EventCntr16)
**
**     Description :
**         This method returns the number of the external events.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the returned number of
**                           the external events
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_OVERFLOW - Timer overflow
** ===================================================================
*/
byte EC161_GetNumEvents(word *Value)
{
  *Value = getReg(TMRA_0_CNTR);        /* Get number of events */
  return ERR_OK;                       /* Return OK */
}

/*
** ===================================================================
**     Method      :  EC161_Interrupt (component EventCntr16)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void EC161_Interrupt(void)
{
  clrRegBit(TMRA_0_SCTRL,TCF);         /* Clear compare interrupt flag */
  EC161_OnEnd();                       /* Invoke user event */
}

/*
** ===================================================================
**     Method      :  EC161_Init (component EventCntr16)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void EC161_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_0_CTRL,0x20);            /* Initialize timer control register */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=1,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_0_SCTRL,0x4000);         /* Enable interrupt on overflow, select input edge polarity */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=0 */
  setReg(TMRA_0_CSCTRL,0x00);          /* Disable interrupt on compare, disable compare preload */
  setReg(TMRA_0_CNTR,0x00);            /* Initialize counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Initialize counter load register */
  setReg(TMRA_0_COMP1,0x270F);         /* Initialize counter compare 1 register */
  /* TMRA_0_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0 */
  setReg(TMRA_0_FILT,0x00);            /* Set up input filter register */
}

/* END EC161. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
