/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : EC321.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : EventCntr32
**     Version     : Component 02.096, Driver 02.06, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:37, # CodeGen: 10
**     Abstract    :
**         This component "EventCntr32" implements an 32-bit event counter.
**         It counts the external events (specified edges of the external
**         signal). It uses a hardware counter that can have different width.
**         In that case the counter will be extended or taperred to 32 bits.
**     Settings    :
**         Timer name                  : TMRA0 [16-bit]
**         Used input pin              : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**         Counter register            : TMRA_0_CNTR [E145]
**         Mode register               : TMRA_0_CTRL [E146]
**         Run register                : TMRA_0_CTRL [E146]
**     Contents    :
**         Enable       - byte EC321_Enable(void);
**         Reset        - byte EC321_Reset(void);
**         GetNumEvents - byte EC321_GetNumEvents(dword *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE EC321. */

#include "Events.h"
#include "EC321.h"

volatile static word High16;           /* The higher 16 bits of the 32 bit counter */

/*
** ===================================================================
**     Method      :  EC321_Enable (component EventCntr32)
**
**     Description :
**         This method enables the component - the external events are
**         counted.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/
byte EC321_Enable(void)
{
  setRegBitGroup(TMRA_0_CTRL,CM,1);
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  EC321_Reset (component EventCntr32)
**
**     Description :
**         This method resets the external event counter (sets it to
**         zero).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/
byte EC321_Reset(void)
{
  High16 = 0xFFFEu;                    /* Reset the higher 16 bits of the 32 bit counter */
  setReg(TMRA_0_CNTR,65534);           /* Set the lower counter register */
  return ERR_OK;                       /* Return OK */
}

/*
** ===================================================================
**     Method      :  EC321_GetNumEvents (component EventCntr32)
**
**     Description :
**         This method returns the number of the external events.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the returned number of
**                           the external events
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_OVERFLOW - Timer overflow
** ===================================================================
*/
byte EC321_GetNumEvents(dword *Value)
{
  *Value = getReg(TMRA_0_CNTR);        /* Get number of events */
  *Value += ((dword)(High16)<<16U)-0xFFFEFFFEU; /* Get number of events */
  return ERR_OK;                       /* Return OK */
}

/*
** ===================================================================
**     Method      :  EC321_Interrupt (component EventCntr32)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void EC321_Interrupt(void)
{
  clrRegBit(TMRA_0_SCTRL,TOF);         /* Clear overflow interrupt flag */
  if (High16 == 65535U) {              /* If an overflow of the counter occured */
  setReg(TMRA_0_CNTR,0xFFFE);          /* Set counter register */
    High16 = 0xFFFEU;                  /* Set expanding variable */
    EC321_OnEnd();                     /* Invoke user event */
  }
  else {
    High16++;                          /* Increment the higher counter expanding variable */
  }
}

/*
** ===================================================================
**     Method      :  EC321_Init (component EventCntr32)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void EC321_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=0,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_0_CTRL,0x00);            /* Initialize timer control register */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=1,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_0_SCTRL,0x1000);         /* Enable interrupt on Overflow,select input edge polarity */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=0 */
  setReg(TMRA_0_CSCTRL,0x00);          /* Disable interrupt on compare, disable compare preload */
  setReg(TMRA_0_CNTR,0xFFFE);          /* Initialize counter register */
  High16 = 0xFFFEu;                    /* Initialize expanding variable */
  /* TMRA_0_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0 */
  setReg(TMRA_0_FILT,0x00);            /* Set up input filter register */
}

/* END EC321. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
