/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : EC81.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : EventCntr8
**     Version     : Component 02.100, Driver 02.06, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:38, # CodeGen: 12
**     Abstract    :
**         This component "EventCntr8" implements an 8-bit event counter.
**         It counts the external events (specified edges of the external
**         signal). It uses a hardware counter that can have different width.
**         In that case the counter will be extended or taperred to 8 bits.
**     Settings    :
**         Timer name                  : TMRA1 [16-bit]
**         Used input pin              : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       12            |  GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**             ----------------------------------------------------
**         Counter register            : TMRA_1_CNTR [E155]
**         Mode register               : TMRA_1_CTRL [E156]
**         Run register                : TMRA_1_CTRL [E156]
**     Contents    :
**         Enable       - byte EC81_Enable(void);
**         Reset        - byte EC81_Reset(void);
**         GetNumEvents - byte EC81_GetNumEvents(byte *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE EC81. */

#include "Events.h"
#include "EC81.h"

/*
** ===================================================================
**     Method      :  EC81_Enable (component EventCntr8)
**
**     Description :
**         This method enables the component: the external events are counted.
**     Parameters  : None
**     Returns     :
**         ---        - Error code
** ===================================================================
*/
byte EC81_Enable(void)
{
  setRegBitGroup(TMRA_1_CTRL,CM,1);
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  EC81_Reset (component EventCntr8)
**
**     Description :
**         This method resets the external event counter (sets it to zero).
**     Parameters  : None
**     Returns     :
**         ---        - Error code
** ===================================================================
*/
byte EC81_Reset(void)
{
  setReg(TMRA_1_CNTR,0x00);            /* Set counter register */
  return ERR_OK;                       /* Return OK */
}

/*
** ===================================================================
**     Method      :  EC81_GetNumEvents (component EventCntr8)
**
**     Description :
**         This method returns the number of the external events.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the returned number of
**                           the external events
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_OVERFLOW - Timer overflow
** ===================================================================
*/
byte EC81_GetNumEvents(byte *Value)
{
  *Value = (byte)getReg(TMRA_1_CNTR);  /* Get number of events */
  return ERR_OK;                       /* Return OK */
}

/*
** ===================================================================
**     Method      :  EC81_Interrupt (component EventCntr8)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void EC81_Interrupt(void)
{
  clrRegBit(TMRA_1_SCTRL,TCF);         /* Clear compare interrupt flag */
  EC81_OnEnd();                        /* Invoke user event */
}

/*
** ===================================================================
**     Method      :  EC81_Init (component EventCntr8)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void EC81_Init(void)
{
  /* TMRA_1_CTRL: CM=0,PCS=1,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_1_CTRL,0x0220);          /* Initialize timer control register */
  /* TMRA_1_SCTRL: TCF=0,TCFIE=1,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_1_SCTRL,0x4000);         /* Enable interrupt on overflow, select input edge polarity */
  /* TMRA_1_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=0 */
  setReg(TMRA_1_CSCTRL,0x00);          /* Disable interrupt on compare, disable compare preload */
  setReg(TMRA_1_CNTR,0x00);            /* Initialize counter register */
  setReg(TMRA_1_LOAD,0x00);            /* Initialize counter load register */
  setReg(TMRA_1_COMP1,0xFE);           /* Initialize counter compare 1 register */
  /* TMRA_1_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0 */
  setReg(TMRA_1_FILT,0x00);            /* Set up input filter register */
}

/* END EC81. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
