/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Init_MSCAN
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 13:30, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Init_MSCAN */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "CAN.h"
#include "TEST1.h"
#include "FC1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define CAN_MSG_ID   1U
#define CAN_MSG_LEN  8U

UInt32 TxLowByte;
UInt32 TxHighByte;
UInt32 RxLowByte;
UInt32 RxHighByte;
byte i, msgLen;
volatile byte OnFreeTxBuffer = 0;
volatile byte OnFullRxBuffer = 0;
dword msgID;
bool cmpFailed;

void main(void)
{
  test_sRec testRec;


  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Init_FlexCAN test");
  //
  RxLowByte = 0xFFFFFFFFUL;
  RxHighByte = 0xFFFFFFFFUL;
  
  TxLowByte = 0x8899AABBUL;
  TxHighByte = 0xCCDDEEFFUL;
  PESL(CANMB1, FCANMB_SET_DATA_WORD0, 0x00UL); /* Clear Data field*/
  PESL(CANMB1, FCANMB_SET_DATA_WORD1, 0x00UL); /* Clear Data field*/  
  PESL(CANMB1, FCANMB_SET_ID_TYPE, FCANMB_STANDARD); /* Extended Frame bit IDE clear*/
  PESL(CANMB1, FCANMB_SRR, FCANMB_DISABLE);  /* SRR set to 0 */
  PESL(CANMB1, FCANMB_RTR, FCANMB_DISABLE);  /* RTR set to 0*/  
  PESL(CANMB1, FCANMB_SET_ID_STD, CAN_MSG_ID );
  PESL(CANMB1, FCANMB_SET_CODE, FCANMB_RX_EMPTY);
  
  //
  TEST1_testComment(&testRec, "Transmitting CAN message (ID=1) ...");
   
  PESL(CANMB0, FCANMB_SET_DATA_LENGTH, CAN_MSG_LEN);
  PESL(CANMB0, FCANMB_SET_ID_TYPE, FCANMB_STANDARD); /* Extended Frame bit IDE clear*/
  PESL(CANMB0, FCANMB_SRR, FCANMB_DISABLE);  /* SRR set to 0 */
  PESL(CANMB0, FCANMB_RTR, FCANMB_DISABLE);  /* RTR set to 0*/
  PESL(CANMB0, FCANMB_SET_ID_STD, CAN_MSG_ID );
  PESL(CANMB0 , FCANMB_SET_DATA_WORD0 , TxLowByte );
  PESL(CANMB0 , FCANMB_SET_DATA_WORD1 , TxHighByte );
  
  PESL(CANMB0, FCANMB_SET_CODE, FCANMB_TX_DATA_FRAME );
  //
  while (OnFreeTxBuffer == 0) {}
  TEST1_testComment(&testRec, "PASSED");
  //
  TEST1_testComment(&testRec, "Receiving CAN message ...");
  while (OnFullRxBuffer == 0) {}
  msgID = PESL(CANMB1, FCANMB_GET_ID_STD, NULL);
  msgLen = PESL(CANMB1, FCANMB_GET_DATA_LENGTH, NULL );
  RxLowByte = PESL(CANMB1, FCANMB_GET_DATA_WORD0 , NULL);
  RxHighByte = PESL(CANMB1, FCANMB_GET_DATA_WORD1 , NULL);
  TEST1_testComment(&testRec, "PASSED");
  //
  if (msgID != CAN_MSG_ID) {
    TEST1_testFailed(&testRec, "Received message ID is different");
  } else {
    if (msgLen != CAN_MSG_LEN) {
      TEST1_testFailed(&testRec, "Received message length is different");
    }
  }
  //
  TEST1_testComment(&testRec, "Comparing received/sent CAN message ...");
  cmpFailed = ( TxHighByte != RxHighByte ) || ( TxLowByte != RxLowByte );

  if (cmpFailed) {
    TEST1_testFailed(&testRec, "Comparing received/sent CAN message failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }
  //
  TEST1_testEnd(&testRec);
  //
}


/* END demo_Init_MSCAN */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
