/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : AD1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : ADC
**     Version     : Component 01.650, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:51, # CodeGen: 8
**     Abstract    :
**         This device "ADC" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
**     Settings    :
**          Component name                                 : AD1
**          A/D converter                                  : ADC12
**          Sharing                                        : Disabled
**          Interrupt service/event                        : Disabled
**          A/D channels                                   : 1
**            Channel0                                     : 
**              A/D channel (pin)                          : GPIOA7/ANA7/ANC11
**              A/D channel (pin) signal                   : 
**              Amplifier                                  : x 1
**              Mode select                                : Single Ended
**          ANA7 internal source                           : Disabled
**          ANB7 internal source                           : Disabled
**          Queue                                          : Enabled
**            Mode                                         : Sequential
**            A/D samples                                  : 16
**              Sample0                                    : Enabled
**                Channel                                  : 0
**                High limit                               : 32760
**                Low limit                                : 0
**                Offset                                   : 0
**                Zero crossing                            : Disabled
**              Sample1                                    : Disabled
**              Sample2                                    : Disabled
**              Sample3                                    : Disabled
**              Sample4                                    : Disabled
**              Sample5                                    : Disabled
**              Sample6                                    : Disabled
**              Sample7                                    : Disabled
**              Sample8                                    : Disabled
**              Sample9                                    : Disabled
**              Sample10                                   : Disabled
**              Sample11                                   : Disabled
**              Sample12                                   : Disabled
**              Sample13                                   : Disabled
**              Sample14                                   : Disabled
**              Sample15                                   : Disabled
**          A/D resolution                                 : Autoselect
**          Conversion time                                : 5.44 s
**          Sample time                                    : 5 clock periods
**          Internal trigger                               : Disabled
**          Volt. ref. recovery time                       : 100
**          Power up delay                                 : 13
**          Power savings mode                             : Disabled
**          Auto standby                                   : Disabled
**          Volt. ref. source                              : controlled by this component for both converter
**            High volt. ref. source                       : internal
**            Low volt. ref. source                        : internal
**            High volt. ref. source                       : internal
**            Low volt. ref. source                        : internal
**          Number of conversions                          : 1
**          Initialization                                 : 
**            Enabled in init. code                        : yes
**            Events enabled in init.                      : yes
**          CPU clock/speed selection                      : 
**            High speed mode                              : This component enabled
**            Low speed mode                               : This component disabled
**            Slow speed mode                              : This component disabled
**          High input limit                               : 1
**          Low input limit                                : 0
**          Get value directly                             : yes
**          Wait for result                                : yes
**     Contents    :
**         Measure    - byte AD1_Measure(bool WaitForResult);
**         GetValue16 - byte AD1_GetValue16(word *Values);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE AD1. */

#include "AD1.h"

#define IDLE            0U             /* IDLE state           */
#define MEASURE         1U             /* MEASURE state        */
#define CONTINUOUS      2U             /* CONTINUOUS state     */
#define SINGLE          3U             /* SINGLE state         */

static bool OutFlg;                    /* Measurement finish flag */
/*lint -esym(765,AD1_ModeFlg) Disable MISRA rule (8.10) checking for symbols (AD1_ModeFlg). */
volatile byte AD1_ModeFlg;             /* Current state of device */

/*
** ===================================================================
**     Method      :  MainMeasure (component ADC)
**
**     Description :
**         The method performs A/D conversion(s). The method is called 
**         automatically as a part of measure methods or the HWEnDi 
**         method.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void MainMeasure(void)
{
  if (getRegBit(ADC12_STAT,EOSI0)) {   /* Is a scan cycle completed? */
    setRegBits(ADC12_STAT,0x0800);     /* Clear EOSI flag */
    OutFlg = TRUE;                     /* Measured values are available */
    AD1_ModeFlg = IDLE;                /* Set the component to the idle mode */
  }
}

/*
** ===================================================================
**     Method      :  HWEnDi (component ADC)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the 
**         component. The method is called automatically as a part of 
**         Enable, Disable and Init methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (AD1_ModeFlg) {                   /* Launch measurement? */
    OutFlg = FALSE;                    /* Measured values are available */
    setRegBits(ADC12_STAT,0x0800);     /* Clear flag */
    clrRegBit(ADC12_CTRL1,STOP0);      /* Normal operation mode */
    setRegBit(ADC12_CTRL1,START0);     /* Launching of conversion */
  }
  else {
    setRegBit(ADC12_CTRL1,STOP0);      /* Stop command issued */
  }
}

/*
** ===================================================================
**     Method      :  AD1_Measure (component ADC)
**
**     Description :
**         This method performs one measurement on all channels that
**         are set in the component inspector. (Note: If the <number of
**         conversions> is more than one the conversion of A/D channels
**         is performed specified number of times.)
**     Parameters  :
**         NAME            - DESCRIPTION
**         WaitForResult   - Wait for a result of a
**                           conversion. If <interrupt service> is
**                           disabled, A/D peripheral doesn't support
**                           measuring all channels at once or Autoscan
**                           mode property isn't enabled and at the same
**                           time the <number of channel> is greater
**                           than 1, then the WaitForResult parameter is
**                           ignored and the method waits for each
**                           result every time. If the <interrupt
**                           service> is disabled and a <number of
**                           conversions> is greater than 1, the
**                           parameter is ignored and the method also
**                           waits for each result every time.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - Device is disabled
**                           ERR_BUSY - A conversion is already running
** ===================================================================
*/
byte AD1_Measure(bool WaitForResult)
{
  if (AD1_ModeFlg != IDLE) {           /* Is the device in running mode? */
    return ERR_BUSY;                   /* If yes then error */
  }
  AD1_ModeFlg = MEASURE;               /* Set state of device to the measure mode */
  HWEnDi();                            /* Enable the device */
  if (WaitForResult) {                 /* Is WaitForResult TRUE? */
    while (AD1_ModeFlg == MEASURE) {   /* Calling MainMeasure while IDLE state occured */
      MainMeasure();                   /* A/D converter handler */
    }
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AD1_GetValue16 (component ADC)
**
**     Description :
**         This method returns the last measured values of all channels
**         justified to the left. Compared with <GetValue> method this
**         method returns more accurate result if the <number of
**         conversions> is greater than 1 and <AD resolution> is less
**         than 16 bits. In addition, the user code dependency on <AD
**         resolution> is eliminated.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Values          - Pointer to the array that contains
**                           the measured data.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_OVERRUN - External trigger overrun flag
**                           was detected after the last value(s) was
**                           obtained (for example by GetValue). This
**                           error may not be supported on some CPUs
**                           (see generated code).
** ===================================================================
*/
byte AD1_GetValue16(word *Values)
{
  if (AD1_ModeFlg != IDLE) {           /* Is the device in any measure mode? */
    MainMeasure();                     /* Call A/D converter handler */
  }
  if (!OutFlg) {                       /* Is measured value(s) available? */
    return ERR_NOTAVAIL;               /* If no then error */
  }
  *Values = (getReg(ADC12_RSLT0) + 0x00U) << 1U; /* Store value from result register of device to user buffer */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AD1_Init (component ADC)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void AD1_Init(void)
{
  volatile word i;

  OutFlg = FALSE;                      /* No measured value */
  AD1_ModeFlg = IDLE;                  /* Device isn't running */
  /* ADC12_CTRL1: DMAEN0=0,STOP0=1,START0=0,SYNC0=0,EOSIE0=0,ZCIE=0,LLMTIE=0,HLMTIE=0,CHNCFG_L=0,??=0,SMODE=0 */
  setReg(ADC12_CTRL1,0x4000U);         /* Set control register 1 */
  /* ADC12_CTRL3: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DMASRC=0,SCNT1=0,SCNT0=3 */
  setReg(ADC12_CTRL3,0x03U);           /* Set control register 3 */
  /* ADC12_CAL: SEL_VREFH_B=0,SEL_VREFLO_B=0,SEL_VREFH_A=0,SEL_VREFLO_A=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SEL_DAC_B=0,SEL_DAC_A=0 */
  setReg(ADC12_CAL,0x00U);             /* Set calibration register */
  /* ADC12_PWR: ASB=0,??=0,??=0,??=0,PSTS1=0,PSTS0=0,PUDELAY=0x0D,APD=0,??=0,PD1=1,PD0=0 */
  setReg(ADC12_PWR,0xD2U);             /* Enable device */
  /* ADC12_OFFST0: ??=0,OFFSET=0,??=0,??=0,??=0 */
  setReg(ADC12_OFFST0,0x00U);          /* Set offset reg. 0 */
  /* ADC12_HILIM0: ??=0,HLMT=0x0FFF,??=0,??=0,??=0 */
  setReg(ADC12_HILIM0,0x7FF8U);        /* Set high limit reg. 0 */
  /* ADC12_LOLIM0: ??=0,LLMT=0,??=0,??=0,??=0 */
  setReg(ADC12_LOLIM0,0x00U);          /* Set low limit reg. 0 */
  /* ADC12_ZXSTAT: ZCS=0xFFFF */
  setReg(ADC12_ZXSTAT,0xFFFF);         /* Clear zero crossing status flags */
  /* ADC12_LOLIMSTAT: LLS=0xFFFF */
  setReg(ADC12_LOLIMSTAT,0xFFFF);      /* Clear high and low limit status */
  /* ADC12_STAT: CIP0=0,CIP1=0,??=0,EOSI1=0,EOSI0=1,ZCI=0,LLMTI=0,HLMTI=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg(ADC12_STAT,0x0800);           /* Clear EOSI flag */
  /* ADC12_SDIS: DS=0xFFFE */
  setReg(ADC12_SDIS,0xFFFEU);          /* Enable/disable of samples */
  /* ADC12_CLIST1: SAMPLE3=0,SAMPLE2=0,SAMPLE1=0,SAMPLE0=7 */
  setReg(ADC12_CLIST1,0x07U);          /* Set ADC channel list reg. */
  /* ADC12_ZXCTRL1: ZCE7=0,ZCE6=0,ZCE5=0,ZCE4=0,ZCE3=0,ZCE2=0,ZCE1=0,ZCE0=0 */
  setReg(ADC12_ZXCTRL1,0x00U);         /* Set zero crossing control reg. */
  /* ADC12_ZXCTRL2: ZCE15=0,ZCE14=0,ZCE13=0,ZCE12=0,ZCE11=0,ZCE10=0,ZCE9=0,ZCE8=0 */
  setReg(ADC12_ZXCTRL2,0x00U);         /* Set zero crossing control reg. */
  /* ADC12_CTRL2: DMAEN1=0,STOP1=0,START1=0,SYNC1=0,EOSIE1=0,CHNCFG_H=0,SIMULT=1,DIV0=0x3C */
  setReg(ADC12_CTRL2,0x7CU);           /* Set prescaler */
  /* ADC12_PWR2: ??=0,??=0,DIV1=0,??=0,??=0,??=0,??=0,SPEEDB=0,SPEEDA=0 */
  setReg16(ADC12_PWR2, 0x00U);          
  for (i=0U;i<0x64U;i++) {}            /* Recovery time of voltage reference */
  while (ADC12_PWR&(ADC12_PWR_PSTS0_MASK)) {} /* Wait for device powered up */
}

/* END AD1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
