/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cpu.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : MC56F84789VLL
**     Version     : Component 01.066, Driver 01.00, CPU db: 3.50.001
**     Datasheet   : MC56F847XXRM Rev.0RC 10/201
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:55, # CodeGen: 8
**     Abstract    :
**
**     Settings    :
**
**     Contents    :
**         EnableInt   - void Cpu_EnableInt(void);
**         DisableInt  - void Cpu_DisableInt(void);
**         SetWaitMode - void Cpu_SetWaitMode(void);
**         SetStopMode - void Cpu_SetStopMode(void);
**         Delay100US  - asm void Cpu_Delay100US(word us100);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cpu. */
#include "Bits1.h"
#include "Bit2.h"
#include "TEST1.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


/* Global variables */
volatile word SR_lock = 0U;            /* Lock */
volatile word SR_reg;                  /* Current value of the SR register */
/*
** ===================================================================
**     Method      :  Cpu_Interrupt (component MC56F84789VLL)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{
  asm(DEBUGHLT);                       /* Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Delay100US (component MC56F84789VLL)
**
**     Description :
**         This method realizes software delay. The length of delay
**         is at least 100 microsecond multiply input parameter
**         [us100]. As the delay implementation is not based on real
**         clock, the delay time may be increased by interrupt
**         service routines processed during the delay. Adding read
**         wait states for external program memory can cause delay
**         extension as well. The method is independent on selected
**         speed mode.
**     Parameters  :
**         NAME            - DESCRIPTION
**         us100           - Number of 100 us delay repetitions.
**     Returns     : Nothing
** ===================================================================
*/
/*lint -save  -e586 Disable MISRA rule (2.1) checking. Method is implemented using assembler. */
asm void Cpu_Delay100US(word us100)
{
  /* Total irremovable overhead: about 16 cycles */
  /* move.w: 2 cycles overhead (load parameter into register) */
  /* jsr:    5 cycles overhead (jump to subroutine) */
  /* rts:    8 cycles overhead (return from subroutine) */
  /* nop:    1 cycles overhead (aditional nops) */

  loop:
  /* 100 us delay block begin */
  /*
   * Delay
   *   - requested                  : 100 us @ 200MHz,
   *   - possible                   : 20000 c, 100000 ns
   *   - without removable overhead : 19994 c, 99970 ns
   */
  adda #2, SP                          /* (1 c: 5 ns) move SP forward */
  move.l A10, X:(SP)                   /* (2 c: 10 ns) push A */
  move.w #0x2705, A                    /* (2 c: 10 ns) number of iterations */
  do A, label0                         /* (8 c: 40 ns) repeat 9989x nop */
    nop                                /* (1 c: 5 ns) wait for 1 c */
  label0:
  move.l X:(SP), A                     /* (2 c: 10 ns) pop A */
  suba #2, SP                          /* (1 c: 5 ns) move SP back */
  /* 100 us delay block end */
  dec.w Y0                             /* us100 parameter is passed via Y0 register */
  jne loop                             /* next loop */
  nop                                  /* avoid pipeline conflicts */
  rts                                  /* return from subroutine */
}
/*lint -restore Enable MISRA rule (2.1) checking. */

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (component MC56F84789VLL)
**
**     Description :
**         Disables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (component MC56F84789VLL)
**
**     Description :
**         Enables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetStopMode (component MC56F84789VLL)
**
**     Description :
**         Sets low power mode - Stop mode.
**         For more information about the stop mode see this CPU
**         documentation.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetStopMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetWaitMode (component MC56F84789VLL)
**
**     Description :
**         Sets low power mode - Wait mode.
**         For more information about the wait mode see this CPU
**         documentation.
**         Release from wait mode: Reset or interrupt
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetWaitMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (component MC56F84789VLL)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void init_56800_(void);         /* Forward declaration of external startup function declared in startup file */

/*** !!! Here you can place your own code using property "User data declarations" on the build options tab. !!! ***/

void _EntryPoint(void)
{
  #pragma constarray off

  /*** !!! Here you can place your own code before PE initialization using property "User code before PE initialization" on the build options tab. !!! ***/

  /*** ### MC56F84789VLL "Cpu" init code ... ***/

  /*** PE initialization code after reset ***/

  /* Disable watchdog after reset based on the setting of the "Watchdog" property in CPU component */
  /* COP_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,PSS=3,INTEN=0,CLKSEL=0,CLOREN=0,CSEN=0,CWEN=0,CEN=0,CWP=0 */
  setReg16(COP_CTRL, 0x0300U);          

  /* System clock initialization */
  setRegBitGroup(OCCS_OSCTL1, FREQ_TRIM8M, ((*(word *)0xE42C) & 0x03FFU)); /* Trim the 8MHz internal relaxation oscillator, frequency trim value */
  clrReg16Bit(OCCS_OSCTL1, ROPD);      /* Enable internal 8MHz oscillator */
  setReg16Bit(OCCS_OSCTL1, CLK_MODE);  /* Select an external clock bypass mode */
  setRegBitGroup(OCCS_CTRL, PRECS, 0U); /* Select an internal 8MHz clock source for the CPU core */
  clrSetReg16Bits(OCCS_CTRL, OCCS_CTRL_PLLPD_MASK, OCCS_CTRL_LCKON_MASK); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_DIVBY: LORTP=2,COD=0,??=0,??=0,PLLDB=0x31 */
  setReg16(OCCS_DIVBY, 0x2031U);       /* Set the clock prescalers */ 
  while(!getRegBit(OCCS_STAT, LCK0)){} /* Wait for PLL lock */
  setReg16Bits(OCCS_CTRL, OCCS_CTRL_ZSRC_MASK); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_PROT: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,FRQEP=0,OSCEP=0,PLLEP=0 */
  setReg16(OCCS_PROT, 0x00U);          /* Set the OCCS protection register */ 
  /*** End of PE initialization code after reset ***/

  /*** !!! Here you can place your own code after PE initialization using property "User code after PE initialization" on the build options tab. !!! ***/

  asm(JMP init_56800_);                /* Jump to C startup code */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (component MC56F84789VLL)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
      /* Initialization of the SIM module */
  /* SIM_MISC0: PIT_MSTR=0 */
  clrReg16Bits(SIM_MISC0, 0x01U);       
  /* SIM_CTRL: RST_FILT=0,DMAEbl=3,OnceEbl=0,STOP_disable=0,WAIT_disable=0 */
  clrSetReg16Bits(SIM_CTRL, 0x052FU, 0xC0U); 
  /* SIM_PWR: SR12STDBY=0,SR27PDN=0,SR27STDBY=0,LRSTDBY=0 */
  clrReg16Bits(SIM_PWR, 0xFFU);         
  /* SIM_CLKOUT: CLKODIV=0,CLKDIS1=1,CLKOSEL1=0,CLKDIS0=1,CLKOSEL0=0 */
  clrSetReg16Bits(SIM_CLKOUT, 0xE387U, 0x1020U); 
  /* SIM_PCE0: TA0=0,TA1=0,TA2=0,TA3=0,TB0=0,TB1=0,TB2=0,TB3=0,GPIOA=1,GPIOB=1,GPIOC=1,GPIOD=1,GPIOE=1,GPIOF=1,GPIOG=1 */
  clrSetReg16Bits(SIM_PCE0, 0xFF00U, 0x7FU); 
  /* SIM_PCE1: DAC=0,SCI0=0,SCI1=0,SCI2=0,QSPI0=0,QSPI1=0,QSPI2=0,IIC0=0,IIC1=0,FLEXCAN=0 */
  clrReg16Bits(SIM_PCE1, 0x3FE1U);      
  /* SIM_PCE2: CMPA=0,CMPB=0,CMPC=0,CMPD=0,SARADC=0,CYCADC=0,CRC=0,QDC=0,PIT0=0,PIT1=0,PDB0=0,PDB1=0 */
  clrReg16Bits(SIM_PCE2, 0x1FBFU);      
  /* SIM_PCE3: PWMACH0=0,PWMACH1=0,PWMACH2=0,PWMACH3=0,PWMBCH0=0,PWMBCH1=0,PWMBCH2=0,PWMBCH3=0 */
  clrReg16Bits(SIM_PCE3, 0xFFU);        
  /* SIM_SD0: TA0=0,TA1=0,TA2=0,TA3=0,TB0=0,TB1=0,TB2=0,TB3=0,GPIOA=0,GPIOB=0,GPIOC=0,GPIOD=0,GPIOE=0,GPIOF=0,GPIOG=0 */
  clrReg16Bits(SIM_SD0, 0xFF7FU);       
  /* SIM_SD1: DAC=0,SCI0=0,SCI1=0,SCI2=0,QSPI0=0,QSPI1=0,QSPI2=0,IIC0=0,IIC1=0,FLEXCAN=0 */
  clrReg16Bits(SIM_SD1, 0x3FE1U);       
  /* SIM_SD2: CMPA=0,CMPB=0,CMPC=0,CMPD=0,SARADC=0,CYCADC=0,CRC=0,QDC=0,PIT0=0,PIT1=0,PDB0=0,PDB1=0 */
  clrReg16Bits(SIM_SD2, 0x1FBFU);       
  /* SIM_SD3: PWMACH0=0,PWMACH1=0,PWMACH2=0,PWMACH3=0,PWMBCH0=0,PWMBCH1=0,PWMBCH2=0,PWMBCH3=0 */
  clrReg16Bits(SIM_SD3, 0xFFU);         
  /* SIM_PROT: PMODE=0,GDP=0,PCEP=0,GIPSP=0 */
  clrReg16Bits(SIM_PROT, 0xFFU);        
  /* SIM_PCR: ??=0,??=0,SCI0_CR=1,SCI1_CR=1,SCI2_CR=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg16(SIM_PCR, 0x3800U);          /* Set the QSCI0; QSCI1; QSCI2 module clock rates */ 
      /* Initialization of the MCM module */
  /* MCM_UPRAMBAR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,RBA=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg32(MCM_UPRAMBAR, 0x00UL);       
  /* MCM_UFLASHBAR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,FBA=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg32(MCM_UFLASHBAR, 0x00UL);      
  /* MCM_CPCR: XBARARB=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IBDIS=0,SRDIS=0,RCDIS=0,INSDIS=0,SOCCR=0 */
  setReg32(MCM_CPCR, 0x00UL);           
  /* MCM_RPCR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,RL=0,RPE=0 */
  setReg32(MCM_RPCR, 0x00UL);           
      /* Initialization of the GPIOA module */
  /* GPIOA_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOA_DRIVE, 0x0FFFU);   
  /* GPIOA_SRE: SRE11=0,SRE10=0,SRE9=0,SRE8=0,SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  clrReg16Bits(GPIOA_SRE, 0x0FFFU);     
      /* Initialization of the GPIOB module */
  /* GPIOB_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOB_DRIVE, 0x0FFFU);   
  /* GPIOB_SRE: SRE11=0,SRE10=0,SRE9=0,SRE8=0,SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  clrReg16Bits(GPIOB_SRE, 0x0FFFU);     
      /* Initialization of the GPIOC module */
  /* GPIOC_DRIVE: DRIVE15=0,DRIVE14=0,DRIVE13=0,DRIVE12=0,DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIOC_DRIVE, 0x00U);         
  /* GPIOC_SRE: SRE15=0,SRE14=0,SRE13=0,SRE12=0,SRE11=0,SRE10=0,SRE9=0,SRE8=0,SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  setReg16(GPIOC_SRE, 0x00U);           
      /* Initialization of the GPIOD module */
  /* GPIOD_DRIVE: DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOD_DRIVE, 0xFFU);     
  /* GPIOD_SRE: SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  clrReg16Bits(GPIOD_SRE, 0xFFU);       
      /* Initialization of the GPIOE module */
  /* GPIOE_DRIVE: DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOE_DRIVE, 0x03FFU);   
  /* GPIOE_SRE: SRE9=0,SRE8=0,SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  clrReg16Bits(GPIOE_SRE, 0x03FFU);     
      /* Initialization of the GPIOF module */
  /* GPIOF_DRIVE: DRIVE15=0,DRIVE14=0,DRIVE13=0,DRIVE12=0,DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIOF_DRIVE, 0x00U);         
  /* GPIOF_SRE: SRE15=0,SRE14=0,SRE13=0,SRE12=0,SRE11=0,SRE10=0,SRE9=0,SRE8=0,SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  setReg16(GPIOF_SRE, 0x00U);           
      /* Initialization of the GPIOG module */
  /* GPIOG_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOG_DRIVE, 0x0FFFU);   
  /* GPIOG_SRE: SRE11=0,SRE10=0,SRE9=0,SRE8=0,SRE7=0,SRE6=0,SRE5=0,SRE4=0,SRE3=0,SRE2=0,SRE1=0,SRE0=0 */
  clrReg16Bits(GPIOG_SRE, 0x0FFFU);     
/*lint -save  -e586 Disable MISRA rule (2.1) checking. Functionality is implemented using assembler. */
  /* Shadow registers initialization */
  asm {
    move.l #0, R0
    move.l #0, R1
    move.l #0, R2
    move.l #0, R3
    move.l #0, R4
    move.l #0, R5
    move.l #0, N
    moveu.w #65535, N3
    moveu.w #65535, M01
    nop
    nop
    swap shadows
    /* Reset the M01 register for linear addressing */
    moveu.w #65535,M01
  }
/*lint -restore Enable MISRA rule (2.1) checking. */
  /* Common initialization of the CPU registers */
  /* INTC_IPR12: GPIOA=1 */
  clrSetReg16Bits(INTC_IPR12, 0x20U, 0x10U); 
  /* GPIOA_PUS: PUS7=1,PUS6=1 */
  setReg16Bits(GPIOA_PUS, 0xC0U);       
  /* GPIOA_PUR: PU7=0,PU6=0 */
  clrReg16Bits(GPIOA_PUR, 0xC0U);       
  /* GPIOA_PPMODE: PPMODE7=1,PPMODE6=1 */
  setReg16Bits(GPIOA_PPMODE, 0xC0U);    
  /* GPIOA_DR: D7=0,D6=0 */
  clrReg16Bits(GPIOA_DR, 0xC0U);        
  /* GPIOA_DDR: DD7=0,DD6=0 */
  clrReg16Bits(GPIOA_DDR, 0xC0U);       
  /* GPIOA_PER: PE7=0,PE6=0 */
  clrReg16Bits(GPIOA_PER, 0xC0U);       
  /* GPIOA_IPOLR: IPOL7=0,IPOL6=0 */
  clrReg16Bits(GPIOA_IPOLR, 0xC0U);     
  /* GPIOA_IESR: IES7=1 */
  setReg16Bits(GPIOA_IESR, 0x80U);      
  /* GPIOA_IENR: IEN7=1,IEN6=0 */
  clrSetReg16Bits(GPIOA_IENR, 0x40U, 0x80U); 
  /* GPIOC_PUS: PUS5=1 */
  setReg16Bits(GPIOC_PUS, 0x20U);       
  /* GPIOC_PUR: PU5=0 */
  clrReg16Bits(GPIOC_PUR, 0x20U);       
  /* GPIOC_PPMODE: PPMODE5=1 */
  setReg16Bits(GPIOC_PPMODE, 0x20U);    
  /* GPIOC_DR: D5=0 */
  clrReg16Bits(GPIOC_DR, 0x20U);        
  /* GPIOC_DDR: DD5=0 */
  clrReg16Bits(GPIOC_DDR, 0x20U);       
  /* GPIOC_PER: PE5=0 */
  clrReg16Bits(GPIOC_PER, 0x20U);       
  /* GPIOC_IPOLR: IPOL5=0 */
  clrReg16Bits(GPIOC_IPOLR, 0x20U);     
  /* GPIOC_IENR: IEN5=0 */
  clrReg16Bits(GPIOC_IENR, 0x20U);      
  /* GPIOD_PER: PE4=1 */
  setReg16Bits(GPIOD_PER, 0x10U);       
  /* Initialization of the SIM module */
  /* ### Init_GPIO "Bits1" init code ... */
  /* Bits1_Init(); */
  /* Initialization of the Bits1 is all done in the common initialization of the CPU bean to avoid a multiple access to the same GPIO registers when more Init_GPIO beans use the same GPIO port */
  /* ### Init_GPIO "Bit2" init code ... */
  /* Bit2_Init(); */
  /* Initialization of the Bit2 is all done in the common initialization of the CPU bean to avoid a multiple access to the same GPIO registers when more Init_GPIO beans use the same GPIO port */
  __EI(0);                             /* Enable interrupts of the selected priority level */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
