/** ###################################################################
**     Filename    : Events.c
**     Project     : Init_SPI
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 13:59, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

extern word ISR_Rx_Num;
extern word ISR_Tx_Num;

/*
** ===================================================================
**     Interrupt handler : ISR_Rx
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(ISR_Rx_FAST_INT)
#pragma interrupt fast
#elif defined(ISR_Rx_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void ISR_Rx(void)
{
  PESL(SPI1_DEVICE, SPI_INT_DISABLE, SPI_RX_FULL);
  ISR_Rx_Num++;
}
#if defined(ISR_Rx_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif

/*
** ===================================================================
**     Interrupt handler : ISR_Tx
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(ISR_Tx_FAST_INT)
#pragma interrupt fast
#elif defined(ISR_Tx_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void ISR_Tx(void)
{
  PESL(SPI1_DEVICE, SPI_INT_DISABLE, SPI_TX_EMPTY);
  ISR_Tx_Num++;
}
#if defined(ISR_Tx_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
