/** ###################################################################
**     Filename    : Events.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 18:28, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

extern UInt8 compareInterrupts;
extern UInt16 Ticks[ 6 ];
extern byte edge;

/*
** ===================================================================
**     Event       :  Cap1_OnCapture (module Events)
**
**     Component   :  Cap1 [Capture]
**     Description :
**         This event is called on capturing of Timer/Counter actual
**         value (only when the component is enabled - <Enable> and the
**         events are enabled - <EnableEvent>.This event is available
**         only if a <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Cap1_OnCapture(void)
{
	Cap1_GetCaptureValue( &( Ticks[ edge++ ] ) );
}

/*
** ===================================================================
**     Interrupt handler : PWM_Compare
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(PWM_Compare_FAST_INT)
#pragma interrupt fast
#elif defined(PWM_Compare_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void PWM_Compare(void)
{
  compareInterrupts++;
  PESL(PWMA, PWM_SM0_CLEAR_STATUS_FLAGS, PWM_COMPARE_0_FLAG );
}
#if defined(PWM_Compare_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert 0.00.00 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
