/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : InpPin
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 14:26, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_InpPin */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "InpB1.h"
#include "TO1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

volatile word HighLevelCount=0;
volatile word LowLevelCount=0;
word i;
bool Error;

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "InputPin test");
  TEST1_testComment(&testRec, "Please interconnect pins GPIOC3_TA0_CMPA_O_RXD0 and GPIOC4_TA1_CMPB_O.");

  Error = FALSE;
  for (i = 0; i < 1000; i++) {
    /* If high level is on the pin */
    if (InpB1_GetVal()) {
      /* then increment a high counter */
      HighLevelCount++;
    }
    else {
      /* else increment a low counter */
      LowLevelCount++;
    }
    Cpu_Delay100US(5);
  }
  
  if ((HighLevelCount < 480) || (LowLevelCount < 480)) {
    Error = TRUE;
  }
  if (((HighLevelCount > LowLevelCount)? (HighLevelCount - LowLevelCount): (LowLevelCount - HighLevelCount)) > 10) {
    Error = TRUE;
  }

  if (Error) {
    TEST1_testFailed(&testRec, "GetVal test.");
  } 
  else {
    TEST1_testComment(&testRec, "GetVal test OK.");
  }  
 
  TEST1_testEnd(&testRec);
}

/* END demo_InpPin */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
