/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cap2.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Capture
**     Version     : Component 02.216, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-27, 15:13, # CodeGen: 2
**     Abstract    :
**         This component "Capture" simply implements the capture function
**         of timer. The counter counts the same way as in free run mode. On
**         the selected edge of the input signal (on the input pin), the current
**         content of the counter register is written into the capture
**         register and the OnCapture event is called.
**     Driver      :
**         It is recommended to use method GetCaptureValue in event OnCapture.
**         Content of the capture register is protected from update only
**         to end of event Cap2_OnCapture.
**     Settings    :
**             Timer capture encapsulation : Capture
**
**         Timer
**             Timer                   : TMRA3
**             Counter shared          : No
**
**         High speed mode
**             Prescaler               : divide-by-128
**           Maximal time for capture register
**             Xtal ticks              : 671089
**             microseconds            : 83886
**             milliseconds            : 84
**             seconds (real)          : 0.08388608
**             Hz                      : 12
**           One tick of timer is
**             microseconds            : 1.28
**
**         Initialization:
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Capture                : TMRA_3_CAPT [E172]
**              Counter                : TMRA_3_CNTR [E175]
**              Mode                   : TMRA_3_CTRL [E176]
**              Run                    : TMRA_3_CTRL [E176]
**              Prescaler              : TMRA_3_CTRL [E176]
**
**         Used input pin              : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       76            |  GPIOC13/TA3/XB_IN6/EWM_OUT_B
**             ----------------------------------------------------
**
**         Port name                   : GPIOC_High
**         Bit number (in port)        : 13
**         Bit mask of the port        : 2000
**
**         Signal edge/level           : both
**         Priority                    : 2
**         Pull option                 : off
**
**     Contents    :
**         Reset           - byte Cap2_Reset(void);
**         GetCaptureValue - byte Cap2_GetCaptureValue(Cap2_TCapturedValue *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cap2. */

#include "Events.h"
#include "Cap2.h"


/* Internal method prototypes */

/*
** ===================================================================
**     Method      :  Cap2_Reset (component Capture)
**
**     Description :
**         This method resets the counter register (see implementation
**         note in <General Info>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap2_Reset(void)
{
  setReg(TMRA_3_CNTR,0x00);            /* Reset counter register */
  clrRegBit(TMRA_3_SCTRL,IEF);         /* Clear input edge flag - enable updating of capture register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap2_GetCaptureValue (component Capture)
**
**     Description :
**         This method gets the last value captured by enabled timer.
**         Note: one tick of timer is
**               1.28 us in high speed mode
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the content of the
**                           capture register
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap2_GetCaptureValue(Cap2_TCapturedValue *Value)
{
  *Value = getReg(TMRA_3_CAPT);        /* Return captured value of counter register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap2_Init (component Capture)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Cap2_Init(void)
{
  /* TMRA_3_CTRL: CM=0,PCS=0,SCS=3,ONCE=0,LENGTH=0,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_3_CTRL,0x0180);          /* Set up mode */
  /* TMRA_3_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=1,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_3_SCTRL,0x0400);
  setReg(TMRA_3_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_3_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_3_CAPT,0x00);            /* Reset capture register */
  /* TMRA_3_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0x64 */
  setReg(TMRA_3_FILT,0x64);            /* Set up input filter register */
  setRegBitGroup(TMRA_3_CTRL,PCS,0x0F); /* Set prescaler register according to the selected high speed CPU mode */
  setRegBitGroup(TMRA_3_CTRL,CM,0x01); /* Run counter */
  setRegBitGroup(TMRA_3_SCTRL,CAPTURE_MODE,0x03); /* Enable capture */
}

/*
** ===================================================================
**     Method      :  Cap2_Interrupt (component Capture)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void Cap2_Interrupt(void)
{
  Cap2_OnCapture();                    /* Invoke user event */
  clrRegBit(TMRA_3_SCTRL,IEF);         /* Reset interrupt request flag and enable updating of the capture register */
}

/* END Cap2. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
