/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : EInt1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : ExtInt
**     Version     : Component 02.101, Driver 02.06, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 21:22, # CodeGen: 29
**     Abstract    :
**         This component "ExtInt" implements an external 
**         interrupt, its control methods and interrupt/event 
**         handling procedure.
**         The component uses one pin which generates interrupt on 
**         selected edge.
**     Settings    :
**         Interrupt name              : INT_GPIOF
**         User handling procedure     : EInt1_OnInterrupt
**
**         Used pin                    :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       94            |  GPIOF6/TB2/PWMA_3X/PWMB_3X/XB_IN2
**             ----------------------------------------------------
**
**         Port name                   : GPIOF_Low
**
**         Bit number (in port)        : 6
**         Bit mask of the port        : 0040
**
**         Signal edge/level           : falling
**         Priority                    : 0
**         Pull option                 : off
**         Initial state               : Enabled
**
**         Edge register               : GPIOF_IPOLR [E256]
**         Enable register             : GPIOF_IENR [E255]
**         Request register            : GPIOF_IESR [E258]
**
**         Port data register          : GPIOF_DR  [E251]
**         Port control register       : GPIOF_DDR [E252]
**         Port function register      : GPIOF_PER [E253]
**     Contents    :
**         Enable  - void EInt1_Enable(void);
**         Disable - void EInt1_Disable(void);
**         GetVal  - bool EInt1_GetVal(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __EInt1_H
#define __EInt1_H

/* MODULE EInt1. */

/*Including shared modules, which are used in the whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


#define EInt1_PIN_MASK          ((byte)0x40) /* Pin mask */

void EInt1_Enable(void);
/*
** ===================================================================
**     Method      :  EInt1_Enable (component ExtInt)
**
**     Description :
**         Enable the component - the external events are accepted.
**         This method is available only if HW module allows
**         enable/disable of the interrupt.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define EInt1_Disable() (clrRegBits(GPIOF_IENR,EInt1_PIN_MASK)) /* Disable interrupt "INT_GPIOF" */
/*
** ===================================================================
**     Method      :  EInt1_Disable (component ExtInt)
**
**     Description :
**         Disable the component - the external events are not accepted.
**         This method is available only if HW module allows
**         enable/disable of the interrupt.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define EInt1_GetVal() ((bool)(getRegBits(GPIOF_RAWDATA,EInt1_PIN_MASK)))
/*
** ===================================================================
**     Method      :  EInt1_GetVal (component ExtInt)
**
**     Description :
**         Returns the actual value of the input pin of the component.
**     Parameters  : None
**     Returns     :
**         ---             - Returned input value. Possible values:
**                           <false> - logical "0" (Low level) <true> -
**                           logical "1" (High level)
** ===================================================================
*/

/* END EInt1. */

#endif /* __EInt1_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
