/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : EInt2.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : ExtInt
**     Version     : Component 02.101, Driver 02.06, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-27, 15:13, # CodeGen: 2
**     Abstract    :
**         This component "ExtInt" implements an external 
**         interrupt, its control methods and interrupt/event 
**         handling procedure.
**         The component uses one pin which generates interrupt on 
**         selected edge.
**     Settings    :
**         Interrupt name              : INT_GPIOF
**         User handling procedure     : EInt2_OnInterrupt
**
**         Used pin                    :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       95            |  GPIOF7/TB3/CMPC_O/SS1_B/XB_IN3
**             ----------------------------------------------------
**
**         Port name                   : GPIOF_Low
**
**         Bit number (in port)        : 7
**         Bit mask of the port        : 0080
**
**         Signal edge/level           : falling
**         Priority                    : 0
**         Pull option                 : off
**         Initial state               : Enabled
**
**         Edge register               : GPIOF_IPOLR [E256]
**         Enable register             : GPIOF_IENR [E255]
**         Request register            : GPIOF_IESR [E258]
**
**         Port data register          : GPIOF_DR  [E251]
**         Port control register       : GPIOF_DDR [E252]
**         Port function register      : GPIOF_PER [E253]
**     Contents    :
**         Enable  - void EInt2_Enable(void);
**         Disable - void EInt2_Disable(void);
**         GetVal  - bool EInt2_GetVal(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __EInt2_H
#define __EInt2_H

/* MODULE EInt2. */

/*Including shared modules, which are used in the whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


#define EInt2_PIN_MASK          ((byte)0x80) /* Pin mask */

void EInt2_Enable(void);
/*
** ===================================================================
**     Method      :  EInt2_Enable (component ExtInt)
**
**     Description :
**         Enable the component - the external events are accepted.
**         This method is available only if HW module allows
**         enable/disable of the interrupt.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define EInt2_Disable() (clrRegBits(GPIOF_IENR,EInt2_PIN_MASK)) /* Disable interrupt "INT_GPIOF" */
/*
** ===================================================================
**     Method      :  EInt2_Disable (component ExtInt)
**
**     Description :
**         Disable the component - the external events are not accepted.
**         This method is available only if HW module allows
**         enable/disable of the interrupt.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define EInt2_GetVal() ((bool)(getRegBits(GPIOF_RAWDATA,EInt2_PIN_MASK)))
/*
** ===================================================================
**     Method      :  EInt2_GetVal (component ExtInt)
**
**     Description :
**         Returns the actual value of the input pin of the component.
**     Parameters  : None
**     Returns     :
**         ---             - Returned input value. Possible values:
**                           <false> - logical "0" (Low level) <true> -
**                           logical "1" (High level)
** ===================================================================
*/

/* END EInt2. */

#endif /* __EInt2_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
