/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : MC2.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : MC_Ramp
**     Version     : Component 01.009, Driver 01.03, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-27, 15:13, # CodeGen: 2
**     Abstract    :
**          The Ramp Generation Algorithm generates the acceleration ramp.
**          The RampGetValue function computes the next value of acceleration
**          ramp related to the current acceleration ramp direction.
**     Settings    :
**          This bean has no settings.
**     Contents    :
**         rampGetValue - Frac16 MC2_rampGetValue(Frac16 incrementUp, Frac16 incrementDown, Frac16...
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE MC2. */

#include "MC2.h"

/*
** ===================================================================
**     Method      :  MC2_rampGetValue (component MC_Ramp)
**
**     Description :
**         The function performs a linear Ramp generation determined by
**         input parameters.
**     Parameters  :
**         NAME            - DESCRIPTION
**         incrementUp     - Increment up.
**         incrementDown   - Increment down.
**       * p_actualValue   - Pointer to variable
**                           containing actualValue.
**       * p_requestedValue - Pointer to
**                           variable containing requestedValue.
**     Returns     :
**         ---             - If the requestedValue is greater than
**                           actualValue, the rampGetValue function
**                           returns actualValue + incrementUp until the
**                           maximum is reached, (maximum is
**                           requestedValue), at which point it will
**                           return requestedValue. If the
**                           requestedValue is less than actualValue,
**                           the rampGetValue function returns
**                           actualValue - incrementDown until the
**                           minimum is reached, (minimum is
**                           requestedValue), at which point it will
**                           return requestedValue.
** ===================================================================
*/
Frac16 MC2_rampGetValue(Frac16 incrementUp,Frac16 incrementDown,Frac16 *p_actualValue,Frac16 *p_requestedValue)
{
  /* is there space to increment ? */
  if (*p_actualValue < (*p_requestedValue - incrementUp)) {
    return(*p_actualValue + incrementUp); /* increment up */
  }
  /* is there space to decrement ? */
  if (*p_actualValue > (*p_requestedValue + incrementDown)) {
    return(*p_actualValue - incrementDown); /* increment down */
  }
  else return(*p_requestedValue);      /* saturation */
}

/* END MC2. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
