/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PPG1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PPG
**     Version     : Component 02.190, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:21, # CodeGen: 7
**     Abstract    :
**         This component "PPG" implements a programmable
**         pulse generator that generates signal with variable
**         duty and variable cycle (period).
**     Settings    :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**
**         Timer name                  : TMRA0 [16-bit]
**         Counter                     : TMRA_0_CNTR [E145]
**         Mode register               : TMRA_0_CTRL [E146]
**         Run register                : TMRA_0_CTRL [E146]
**         Prescaler                   : TMRA_0_CTRL [E146]
**         Compare 1 register          : TMRA_0_COMP1 [E140]
**         Compare 2 register          : TMRA_0_COMP2 [E141]
**         Comparator load 1 register  : TMRA_0_CMPLD1 [E148]
**         Comparator load 2 register  : TMRA_0_CMPLD2 [E149]
**         Flip-flop 1 register        : TMRA_0_SCTRL [E147]
**         Load register               : TMRA_0_LOAD [E143]
**
**         Interrupt name              : INT_TMRA_0
**         Interrupt enable reg.       : TMRA_0_CSCTRL [E14A]
**         Priority                    : 1
**         User handling procedure     : PPG1_OnEnd
**         This event is called when the 3 of cycles is generated
**
**         Output pin
**
**         Port name                   : GPIOC_Low
**         Bit number (in port)        : 3
**         Bit mask of the port        : 0008
**         Port data register          : GPIOC_DR  [E221]
**         Port control register       : GPIOC_DDR [E222]
**         Port function register      : GPIOC_PER [E223]
**
**         Runtime setting period      : none
**         Runtime setting ratio       : none
**         Initialization:
**              Output level           : low
**              Timer                  : Disabled
**              Event                  : Enabled
**         High speed mode
**             Prescaler               : divide-by-16
**             Clock                   : 6250000 Hz
**           Initial value of            period        pulse width (ratio 30%)
**             Xtal ticks              : 80000         24000
**             microseconds            : 10000         3000
**             milliseconds            : 10            3
**             seconds (real)          : 0.01          0.003
**
**     Contents    :
**         Enable  - byte PPG1_Enable(void);
**         Disable - byte PPG1_Disable(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/


/* MODULE PPG1. */

#include "Events.h"
#include "PPG1.h"

static bool EnUser;                    /* Enable/Disable device by user */
static byte Cnt;                       /* Number of periods */

/* Internal method prototypes */
static void HWEnDi(void);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetPV (component PPG)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_0_CTRL,PCS,(8U|(word)Val)); /* Store given value to the prescaler */
}

/*
** ===================================================================
**     Method      :  HWEnDi (component PPG)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    setRegBits(TMRA_0_CTRL,0x2000);    /* Run counter */
  }
  else {                               /* Disable device? */
    clrRegBit(TMRA_0_CTRL,CM0);        /* Stop counter */
    setRegBit(TMRA_0_SCTRL,FORCE);     /* Force output signal level */
    setReg(TMRA_0_CNTR,0);             /* Reset counter */
  }
}

/*
** ===================================================================
**     Method      :  PPG1_Enable (component PPG)
**
**     Description :
**         This method enables the component - it starts the signal
**         generation. Events may be generated (<DisableEvent>
**         /<EnableEvent>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte PPG1_Enable(void)
{
  if (!EnUser) {                       /* Is the device disabled by user? */
    EnUser = TRUE;                     /* If yes then set the flag "device enabled" */
    HWEnDi();                          /* Enable the device */

  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PPG1_Disable (component PPG)
**
**     Description :
**         This method disables the component - it stops the signal
**         generation and events calling. When the timer is disabled,
**         it is possible to call <ClrValue> and <SetValue> methods.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte PPG1_Disable(void)
{
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PPG1_Init (component PPG)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PPG1_Init(void)
{
  setReg(TMRA_0_LOAD,0);               /* Clear load register */
  setReg(TMRA_0_CNTR,0);               /* Clear counter */
  Cnt = 0;                             /* Number of period */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=1,OPS=0,OEN=1 */
  setReg(TMRA_0_SCTRL,5);              /* Set Status and Control Register */
  /* TMRA_0_CSCTRL: TCF2EN=1,TCF1EN=0,TCF2=0,TCF1=0,CL2=1,CL1=2 */
  setReg(TMRA_0_CSCTRL,134);           /* Set Comparator Status and Control Register */
  EnUser = FALSE;                      /* Disable device */
  setReg(TMRA_0_COMP1,0x493D);         /* Set the pulse width of the off time, CMP1 register setting */
  setReg(TMRA_0_COMP2,0xF422 - 0x493D); /* Set the pulse width of the on time, CMP2 register setting  */
  setReg(TMRA_0_CMPLD1,0x493D);        /* Set the pulse width of the off time, CMPLD1 register setting */
  setReg(TMRA_0_CMPLD2,0xF422 - 0x493D); /* Set the pulse width of the on time, CMPLD2 register setting  */
  SetPV((byte)0x04);                   /* Set prescaler register according to the selected high speed CPU mode */
  /* TMRA_0_CTRL: CM=0,PCS=8,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=4 */
  setRegBits(TMRA_0_CTRL,0x1024);      /* Set variable PWM mode and stop counter */
}

/*
** ===================================================================
**     Method      :  PPG1_Interrupt (component PPG)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void PPG1_Interrupt(void)
{
  clrRegBit(TMRA_0_CSCTRL,TCF2);       /* Reset interrupt request flag */
  Cnt++;                               /* Increment number of period */
  if (Cnt == 0x03U) {                  /* Is it now the event time? */
    Cnt = 0U;                          /* Reset counter */
    PPG1_OnEnd();                      /* Invoke user event */
  }
}

/* END PPG1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
