/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : shareTmr.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : RTIshared
**     Version     : Component 02.065, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:27, # CodeGen: 7
**     Abstract    :
**         This component "RTIshared" implements a real-time clock which can be
**         shared by many other components.
**     Settings    :
**         Timer name                  : TMRA0 (16-bit)
**
**             Counter shared          : No
**             Counter                 : TMRA_0_CNTR [E145]
**             Mode register           : TMRA_0_CTRL [E146]
**             Run register            : TMRA_0_CTRL [E146]
**             Prescaler               : TMRA_0_CTRL [E146]
**             Compare register        : TMRA_0_COMP1 [E140]
**             Flip-flop register      : TMRA_0_SCTRL [E147]
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 100000000 Hz
**           Initial period/frequency
**             Xtal ticks              : 4000
**             microseconds            : 500
**             seconds (real)          : 0.0005
**             Hz                      : 2000
**             kHz                     : 2
**
**         Components using RTI:
**             timer2
**             timer1
**     Contents    :
**         No public methods
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE shareTmr. */

#include "timer2.h"
#include "timer1.h"
#include "shareTmr.h"


/* Internal method prototypes */
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component RTIshared)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMRA_0_CMPLD1,Val);           /* Store given value to the compare preload 1 register */
  setReg(TMRA_0_CMPLD2,Val);           /* Store given value to the compare preload 2 register */
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (component RTIshared)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_0_CTRL,PCS,Val); /* Store given value to the prescaler */
  setReg(TMRA_0_CNTR,0);               /* Reset counter */
}

/*
** ===================================================================
**     Method      :  shareTmr_Init (component RTIshared)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void shareTmr_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=4 */
  setReg(TMRA_0_CTRL,0x24);            /* Stop timer, use alternating compare registers */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=1,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_0_SCTRL,0x4000);         /* Enable compare interrupt */
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_0_COMP1,0xC34F);         /* Set up compare 1 register */
  setReg(TMRA_0_COMP2,0xC34F);         /* Set up compare 2 register */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=1,CL1=2 */
  setReg(TMRA_0_CSCTRL,0x06);          /* Compare load control */
  SetCV((word)0xC34F);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x08);                   /* Set prescaler register according to the selected high speed CPU mode */
  setRegBitGroup(TMRA_0_CTRL,CM,0x01); /* Run counter */
}

/*
** ===================================================================
**     Method      :  shareTmr_Interrupt (component RTIshared)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void shareTmr_Interrupt(void)
{
  timer1_Interrupt();
  timer2_Interrupt();
  clrRegBit(TMRA_0_SCTRL,TCF);         /* Reset interrupt request flag */
}

/* END shareTmr. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
