/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TWR_SER_J8_4_5.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroSerial
**     Version     : Component 02.507, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-05-15, 19:30, # CodeGen: 11
**     Abstract    :
**         This component "AsynchroSerial" implements an asynchronous serial
**         communication. The component supports different settings of
**         parity, word width, stop-bit and communication speed,
**         user can select interrupt or polling handler.
**         Communication speed can be changed also in runtime.
**         The component requires one on-chip asynchronous serial channel.
**     Settings    :
**         Serial channel              : QSCI1
**
**         Protocol
**             Init baud rate          : 38400baud
**             Width                   : 8 bits
**             Stop bits               : 1
**             Parity                  : none
**             Breaks                  : Disabled
**             Input buffer size       : 0
**             Output buffer size      : 0
**
**         Registers
**             Input buffer            : QSCI1_DATA [E094]
**             Output buffer           : QSCI1_DATA [E094]
**             Control register        : QSCI1_CTRL1 [E091]
**             Mode register           : QSCI1_CTRL1 [E091]
**             Baud setting reg.       : QSCI1_RATE [E090]
**
**
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     63               |  GPIOF5/RXD1/XB_OUT9
**            Output  |     62               |  GPIOF4/TXD1/XB_OUT8
**         ----------------------------------------------------------
**
**
**
**     Contents    :
**         RecvChar        - byte TWR_SER_J8_4_5_RecvChar(TWR_SER_J8_4_5_TComData *Chr);
**         SendChar        - byte TWR_SER_J8_4_5_SendChar(TWR_SER_J8_4_5_TComData Chr);
**         GetCharsInRxBuf - word TWR_SER_J8_4_5_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word TWR_SER_J8_4_5_GetCharsInTxBuf(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE TWR_SER_J8_4_5. */

#include "TWR_SER_J8_4_5.h"


#define OVERRUN_ERR      0x01U         /* Overrun error flag bit    */
#define FRAMING_ERR      0x02U         /* Framing error flag bit    */
#define PARITY_ERR       0x04U         /* Parity error flag bit     */
#define CHAR_IN_RX       0x08U         /* Char is in RX buffer      */
#define FULL_TX          0x10U         /* Full transmit buffer      */
#define RUNINT_FROM_TX   0x20U         /* Interrupt is in progress  */
#define FULL_RX          0x40U         /* Full receive buffer       */
#define NOISE_ERR        0x80U         /* Noise error flag bit      */
#define IDLE_ERR         0x0100U       /* Idle character flag bit   */
#define BREAK_ERR        0x0200U       /* Break detect              */

static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Unused */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */
                                       /*      11 - Unused */

/*
** ===================================================================
**     Method      :  HWEnDi (component AsynchroSerial)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  setRegBits(QSCI1_CTRL1, (QSCI1_CTRL1_TE_MASK | QSCI1_CTRL1_RE_MASK)); /* Enable device */
}

/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_RecvChar (component AsynchroSerial)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method only sets the selected DMA channel. Then the status
**         of the DMA transfer can be checked using GetCharsInRxBuf
**         method. See an example of a typical usage for details about
**         the communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           <GetError> method can be used for error
**                           specification)
**                           Version specific information for Freescale
**                           56800 derivatives 
**                           DMA mode:
**                           If DMA controller is available on the
**                           selected CPU and the receiver is configured
**                           to use DMA controller then only ERR_OK,
**                           ERR_RXEMPTY, and ERR_SPEED error code can
**                           be returned from this method.
** ===================================================================
*/
byte TWR_SER_J8_4_5_RecvChar(TWR_SER_J8_4_5_TComData *Chr)
{
  register byte Result = ERR_OK;       /* Return error code */
  register word StatReg = getReg(QSCI1_STAT); /* Read status register */

  setReg(QSCI1_STAT, 0x00U);           /* Reset error request flags */
  if ((StatReg & (QSCI1_STAT_OR_MASK|QSCI1_STAT_NF_MASK|QSCI1_STAT_FE_MASK|QSCI1_STAT_PF_MASK)) != 0x00U) { /* Is any error set? */
    Result = ERR_COMMON;               /* If yes then set common error value */
  } else {
    if ((StatReg & QSCI1_STAT_RDRF_MASK) == 0x00U) { /* Is the reciver empty and no error is set? */
      return ERR_RXEMPTY;              /* If yes then error */
    }
  }
  *Chr = (TWR_SER_J8_4_5_TComData)getReg(QSCI1_DATA); /* Read data from the receiver */
  return Result;                       /* Return error code */
}

/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_SendChar (component AsynchroSerial)
**
**     Description :
**         Sends one character to the channel. If the component is
**         temporarily disabled (Disable method) SendChar method only
**         stores data into an output buffer. In case of a zero output
**         buffer size, only one character can be stored. Enabling the
**         component (Enable method) starts the transmission of the
**         stored data. This method is available only if the
**         transmitter property is enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method only sets selected DMA channel. Then the status of
**         the DMA transfer can be checked using GetCharsInTxBuf method.
**         See an example of a typical usage for details about
**         communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/
byte TWR_SER_J8_4_5_SendChar(TWR_SER_J8_4_5_TComData Chr)
{
  if ((getRegBit(QSCI1_STAT, TDRE) == 0x00U)) { /* Is the transmitter empty? */
    return ERR_TXFULL;                 /* If yes then error */
  }
  setReg(QSCI1_DATA, Chr);             /* Store char to transmitter register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_GetCharsInRxBuf (component AsynchroSerial)
**
**     Description :
**         Returns the number of characters in the input buffer. This
**         method is available only if the receiver property is enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method returns the number of characters in the receive
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/
word TWR_SER_J8_4_5_GetCharsInRxBuf(void)
{
  return (word)((getRegBit(QSCI1_STAT, RDRF) != 0U)? 1 : 0); /* Return number of chars in receive buffer */
}

/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_GetCharsInTxBuf (component AsynchroSerial)
**
**     Description :
**         Returns the number of characters in the output buffer. This
**         method is available only if the transmitter property is
**         enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method returns the number of characters in the transmit
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/
word TWR_SER_J8_4_5_GetCharsInTxBuf(void)
{
  return (word)((getRegBit(QSCI1_STAT, TDRE) == 0U)? 1 : 0); /* Return number of chars in the transmitter buffer */
}

/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_Init (component AsynchroSerial)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean internal 
**         variables. The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TWR_SER_J8_4_5_Init(void)
{
  SerFlag = 0x00U;                     /* Reset flags */
  /* QSCI1_CTRL1: LOOP=0,SWAI=0,RSRC=0,M=0,WAKE=0,POL=0,PE=0,PT=0,TEIE=0,TIIE=0,RFIE=0,REIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  setReg(QSCI1_CTRL1, 0x00U);          /* Set the SCI configuration */
  /* QSCI1_RATE: SBR=0x0145,FRAC_SBR=4 */
  setReg(QSCI1_RATE, 0x0A2CU);         /* Set prescaler bits */
  HWEnDi();                            /* Enable/disable device according to status flags */
}


/* END TWR_SER_J8_4_5. */


/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
