/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TWR_SER_J8_4_5.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroSerial
**     Version     : Component 02.507, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-05-15, 19:30, # CodeGen: 11
**     Abstract    :
**         This component "AsynchroSerial" implements an asynchronous serial
**         communication. The component supports different settings of
**         parity, word width, stop-bit and communication speed,
**         user can select interrupt or polling handler.
**         Communication speed can be changed also in runtime.
**         The component requires one on-chip asynchronous serial channel.
**     Settings    :
**         Serial channel              : QSCI1
**
**         Protocol
**             Init baud rate          : 38400baud
**             Width                   : 8 bits
**             Stop bits               : 1
**             Parity                  : none
**             Breaks                  : Disabled
**             Input buffer size       : 0
**             Output buffer size      : 0
**
**         Registers
**             Input buffer            : QSCI1_DATA [E094]
**             Output buffer           : QSCI1_DATA [E094]
**             Control register        : QSCI1_CTRL1 [E091]
**             Mode register           : QSCI1_CTRL1 [E091]
**             Baud setting reg.       : QSCI1_RATE [E090]
**
**
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     63               |  GPIOF5/RXD1/XB_OUT9
**            Output  |     62               |  GPIOF4/TXD1/XB_OUT8
**         ----------------------------------------------------------
**
**
**
**     Contents    :
**         RecvChar        - byte TWR_SER_J8_4_5_RecvChar(TWR_SER_J8_4_5_TComData *Chr);
**         SendChar        - byte TWR_SER_J8_4_5_SendChar(TWR_SER_J8_4_5_TComData Chr);
**         GetCharsInRxBuf - word TWR_SER_J8_4_5_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word TWR_SER_J8_4_5_GetCharsInTxBuf(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __TWR_SER_J8_4_5
#define __TWR_SER_J8_4_5

/* MODULE TWR_SER_J8_4_5. */

#include "Cpu.h"



#ifndef __BWUserType_TWR_SER_J8_4_5_TError
#define __BWUserType_TWR_SER_J8_4_5_TError
  typedef union {
    byte err;
    struct {
      /*lint -save  -e46 Disable MISRA rule (6.4) checking. */
      bool OverRun  : 1;               /* Overrun error flag */
      bool Framing  : 1;               /* Framing error flag */
      bool Parity   : 1;               /* Parity error flag */
      bool RxBufOvf : 1;               /* Rx buffer full error flag */
      bool Noise    : 1;               /* Noise error flag */
      bool Break    : 1;               /* Break detect */
      bool LINSync  : 1;               /* LIN synchronization error */
      bool BitError  : 1;              /* Bit error flag - mismatch to the expected value happened. */
      /*lint -restore Enable MISRA rule (6.4) checking. */
    } errName;
  } TWR_SER_J8_4_5_TError;             /* Error flags. For languages which don't support bit access is byte access only to error flags possible. */
#endif

#ifndef __BWUserType_TWR_SER_J8_4_5_TComData
#define __BWUserType_TWR_SER_J8_4_5_TComData
  typedef byte TWR_SER_J8_4_5_TComData; /* User type for communication. Size of this type depends on the communication data witdh */
#endif

byte TWR_SER_J8_4_5_RecvChar(TWR_SER_J8_4_5_TComData *Chr);
/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_RecvChar (component AsynchroSerial)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method only sets the selected DMA channel. Then the status
**         of the DMA transfer can be checked using GetCharsInRxBuf
**         method. See an example of a typical usage for details about
**         the communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           <GetError> method can be used for error
**                           specification)
**                           Version specific information for Freescale
**                           56800 derivatives 
**                           DMA mode:
**                           If DMA controller is available on the
**                           selected CPU and the receiver is configured
**                           to use DMA controller then only ERR_OK,
**                           ERR_RXEMPTY, and ERR_SPEED error code can
**                           be returned from this method.
** ===================================================================
*/

byte TWR_SER_J8_4_5_SendChar(TWR_SER_J8_4_5_TComData Chr);
/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_SendChar (component AsynchroSerial)
**
**     Description :
**         Sends one character to the channel. If the component is
**         temporarily disabled (Disable method) SendChar method only
**         stores data into an output buffer. In case of a zero output
**         buffer size, only one character can be stored. Enabling the
**         component (Enable method) starts the transmission of the
**         stored data. This method is available only if the
**         transmitter property is enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method only sets selected DMA channel. Then the status of
**         the DMA transfer can be checked using GetCharsInTxBuf method.
**         See an example of a typical usage for details about
**         communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/

word TWR_SER_J8_4_5_GetCharsInRxBuf(void);
/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_GetCharsInRxBuf (component AsynchroSerial)
**
**     Description :
**         Returns the number of characters in the input buffer. This
**         method is available only if the receiver property is enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method returns the number of characters in the receive
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/

word TWR_SER_J8_4_5_GetCharsInTxBuf(void);
/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_GetCharsInTxBuf (component AsynchroSerial)
**
**     Description :
**         Returns the number of characters in the output buffer. This
**         method is available only if the transmitter property is
**         enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method returns the number of characters in the transmit
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/

void TWR_SER_J8_4_5_Init(void);
/*
** ===================================================================
**     Method      :  TWR_SER_J8_4_5_Init (component AsynchroSerial)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean internal 
**         variables. The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/



/* END TWR_SER_J8_4_5. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/

#endif /* ifndef __TWR_SER_J8_4_5 */
