/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : WDog1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : WatchDog
**     Version     : Component 02.136, Driver 02.03, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-05-15, 19:30, # CodeGen: 11
**     Abstract    :
**         This device "WatchDog" implements a watchdog.
**         When enabled, the watchdog timer counts until it reaches
**         a critical value corresponding to the period specified
**         in 'Properties'. Then, the watchdog causes a CPU reset.
**         Applications may clear the timer before it reaches the critical
**         value. The timer then restarts the watchdog counter.
**         Watchdog is used for increasing the safety of the system
**         (unforeseeable situations can cause system crash or an
**         infinite loop - watchdog can restart the system or handle
**         the situation).
**
**         Note: Watchdog can be enabled or disabled in the initialization
**               code only. If the watchdog is once enabled user have
**               to call Clear method in defined time intervals.
**     Settings    :
**         Watchdog causes             : Reset CPU
**
**         Initial Watchdog state      : Enabled
**
**         High speed mode
**           Watchdog period/frequency
**             microseconds            : 2031616
**             milliseconds            : 2032
**             seconds                 : 2
**
**         Run register                : COP_CTRL  [E320]
**         Mode register               : COP_CTRL  [E320]
**         Prescaler register          : COP_TOUT  [E321]
**     Contents    :
**         Enable  - byte WDog1_Enable(void);
**         Disable - byte WDog1_Disable(void);
**         Clear   - byte WDog1_Clear(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __WDog1
#define __WDog1

/* MODULE WDog1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"


byte WDog1_Enable(void);
/*
** ===================================================================
**     Method      :  WDog1_Enable (component WatchDog)
**
**     Description :
**         Enables the component - starts the watchdog timer counting. 
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_PROTECT - This device does is protected
** ===================================================================
*/

byte WDog1_Disable(void);
/*
** ===================================================================
**     Method      :  WDog1_Disable (component WatchDog)
**
**     Description :
**         Disables the component - stops the watchdog timer counting.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_PROTECT - This device does is protected
** ===================================================================
*/

byte WDog1_Clear(void);
/*
** ===================================================================
**     Method      :  WDog1_Clear (component WatchDog)
**
**     Description :
**         Clears the watchdog timer (it makes the timer restart from
**         zero).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - The component is disabled
** ===================================================================
*/

void WDog1_Init(void);
/*
** ===================================================================
**     Method      :  WDog1_Init (component WatchDog)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END WDog1. */

#endif /* ifndef __WDog1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
