/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : SynMastr
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 14:22, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_SynMastr */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SM1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define BLOCKSIZE 17

byte DataOut[] = " Message: Master ";
byte DataIn[BLOCKSIZE];
byte i, err;
word sent, recv;
volatile byte OnTxCharNum = 0;
volatile byte OnRxCharNum = 0;
bool cmpFailed;

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "SynchroMaster test");
  TEST1_testComment(&testRec, "Please interconnect the pins GPIOC8_MISO_RXD0 and GPIOC10_MOSI_XB_IN5_MISO.");
  //
  for (i=0;i<BLOCKSIZE;i++) {
    DataIn[i] = 0x20;
  }
  //
  TEST1_testComment(&testRec, "Transmitting one character ...");
  err = SM1_SendChar(DataOut[1]);
  //
  while (SM1_GetCharsInRxBuf() == 0) {}
  //
  if (err == ERR_OK)
    TEST1_testComment(&testRec, "PASSED");
  else  
    TEST1_testFailed(&testRec, "Transmitting one character failed");
  //
  TEST1_testComment(&testRec, "Receiving one character ...");
  err = SM1_RecvChar(&DataIn[0]);
  if ((err != ERR_OK) || (DataOut[1] != DataIn[0]))
    TEST1_testFailed(&testRec, "Receiving one character failed");
  else  
    TEST1_testComment(&testRec, "PASSED");
  //
  TEST1_testComment(&testRec, "Transmitting data block ...");
  err = SM1_SendBlock(DataOut, BLOCKSIZE, &sent);
  //
  while (SM1_GetCharsInRxBuf() < BLOCKSIZE) {}
  //
  if ((err == ERR_OK) && (sent == BLOCKSIZE))
    TEST1_testComment(&testRec, "PASSED");
  else  
    TEST1_testFailed(&testRec, "Transmitting data block failed");
  //
  TEST1_testComment(&testRec, "Receiving data block ...");
  err = SM1_RecvBlock(DataIn, BLOCKSIZE, &recv);
  if (err != ERR_OK)
    TEST1_testFailed(&testRec, "Receiving data block failed");
  else  
    TEST1_testComment(&testRec, "PASSED");
  //
  TEST1_testComment(&testRec, "Comparing received/sent data ...");
  cmpFailed = FALSE;
  for (i=0;i<BLOCKSIZE;i++) {
    if ( DataOut[i] !=  DataIn[i]) {
      cmpFailed = TRUE;
    } 
  }
  if (cmpFailed) {
    TEST1_testFailed(&testRec, "Comparing received/sent data failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  //
  TEST1_testComment(&testRec, "Testing OnTxCharNum event ...");
  if (OnTxCharNum != BLOCKSIZE + 1) {
    TEST1_testFailed(&testRec, "Testing OnTxCharNum event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  TEST1_testComment(&testRec, "Testing OnRxCharNum event ...");
  if (OnRxCharNum != BLOCKSIZE + 1) {
    TEST1_testFailed(&testRec, "Testing OnRxCharNum event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  //
  TEST1_testEnd(&testRec);
  //
}

/* END demo_SynMastr */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
