/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : TimeDate
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 15:11, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_TimeDate */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "TmDt1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

extern bool Alarm;
extern DATEREC Date;

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Time And Date test");

  Date.Year=2005;
  Date.Month=12;
  Date.Day=31;
  TEST1_testComment(&testRec, "wait 5s for alarm");
  (void)TmDt1_SetAlarm(12,0,0,0);
  do {} while (!Alarm);
  TEST1_testComment(&testRec, "alarm OK");
  
  if (Date.Year != 2008) {
    TEST1_testFailed(&testRec, "year");
  } else {
    TEST1_testComment(&testRec, "year OK");
  }  
  if (Date.Month != 1) {
    TEST1_testFailed(&testRec, "month");
  } else {
    TEST1_testComment(&testRec, "month OK");
  }  
  if (Date.Day != 1) {
    TEST1_testFailed(&testRec, "day");
  } else {
    TEST1_testComment(&testRec, "day OK");
  }  

  TEST1_testEnd(&testRec);

}

/* END demo_TimeDate */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
