/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TO1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : TimerOut
**     Version     : Component 03.023, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 13:54, # CodeGen: 9
**     Abstract    :
**         This component implements a periodic signal generator 1:1 (Flip-Flop Output).
**         The signal alternates the "0" and "1" output values in exactly
**         regular intervals; that is why the time length of the "0" part
**         of one pulse is equal to the "1" part of one pulse.
**     Settings    :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**           Counter shared            : No
**
**         High speed mode
**             Prescaler               : divide-by-16
**             Clock                   : 6250000 Hz
**           Pulse width
**             Xtal ticks              : 80000
**             microseconds            : 10000
**             milliseconds            : 10
**             seconds (real)          : 0.01
**             Hz                      : 100
**
**         Runtime setting             : none
**
**         Initialization:
**              Output level           : low
**              Timer                  : Disabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**
**         Compare registers
**              Compare                : TMRA_0_COMP1 [E140]
**
**         Flip-flop registers
**              Mode                   : TMRA_0_SCTRL [E147]
**     Contents    :
**         Enable  - byte TO1_Enable(void);
**         Disable - byte TO1_Disable(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE TO1. */

#include "Events.h"
#include "TO1.h"

static bool EnUser;                    /* Enable/Disable device by user */


/* Internal method prototypes */
static void HWEnDi(void);
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component TimerOut)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMRA_0_CMPLD1,Val);           /* Store given value to the compare preload register */
  setReg(TMRA_0_CMPLD2,Val);
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (component TimerOut)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_0_CTRL,PCS,Val); /* Store given value to the prescaler */
  setReg(TMRA_0_CNTR,0);               /* Reset counter */
}

/*
** ===================================================================
**     Method      :  HWEnDi (component TimerOut)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    setRegBitGroup(TMRA_0_CTRL,CM,0x01); /* Run counter */
  }
  else {                               /* Disable device? */
    setRegBitGroup(TMRA_0_CTRL,CM,0x00); /* Stop counter */
    setReg(TMRA_0_CNTR,0);             /* Reset counter */
    setRegBit(TMRA_0_SCTRL,FORCE);     /* Force output */
  }
}

/*
** ===================================================================
**     Method      :  TO1_Enable (component TimerOut)
**
**     Description :
**         This method enables the component - It starts the signal
**         generation. Events may be generated (<DisableEvent>
**         /<EnableEvent>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte TO1_Enable(void)
{
  if (!EnUser) {                       /* Is the device disabled by user? */
    EnUser = TRUE;                     /* If yes then set the flag "device enabled" */
    HWEnDi();                          /* Enable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TO1_Disable (component TimerOut)
**
**     Description :
**         This method disables the timer - it stops signal generation
**         and events calling. When the timer is disabled, it is
**         possible to call methods <ClrValue> and <SetValue>.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte TO1_Disable(void)
{
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TO1_Init (component TimerOut)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TO1_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=4 */
  setReg(TMRA_0_CTRL,0x24);            /* Set up mode */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=1,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=1 */
  setReg(TMRA_0_SCTRL,0x4001);
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_0_COMP1,0xF423);         /* Set up compare 1 register */
  setReg(TMRA_0_COMP2,0xF423);         /* Set up compare 2 register */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=1,CL1=2 */
  setReg(TMRA_0_CSCTRL,0x06);          /* Set up comparator control register */
  EnUser = FALSE;                      /* Disable device */
  SetCV((word)0xF423);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x0C);                   /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/*
** ===================================================================
**     Method      :  TO1_Interrupt (component TimerOut)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void TO1_Interrupt(void)
{
  clrRegBit(TMRA_0_SCTRL,TCF);         /* Reset interrupt request flag */
  if (getRegBit(TMRA_0_CSCTRL,TCF2)) { /* Is this compare 2 event? */
    clrRegBit(TMRA_0_CSCTRL,TCF2);     /* Clear flag */
    TO1_OnFalling();                   /* Invoke user event */
  }
}

/* END TO1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
