/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bit2.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : BitIO
**     Version     : Component 02.075, Driver 01.20, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 13:56, # CodeGen: 10
**     Abstract    :
**         This component "BitIO" implements an one-bit input/output.
**         It uses one bit/pin of a port.
**         Methods of this component are mostly implemented as a macros
**         (if supported by target language and compiler).
**     Settings    :
**         Used pin                    :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       77            |  GPIOF1/CLKO1/XB_IN7/CMPD_O
**             ----------------------------------------------------
**
**         Port name                   : GPIOF_Low
**
**         Bit number (in port)        : 1
**         Bit mask of the port        : 0002
**
**         Initial direction           : Input (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0
**         Initial pull option         : off
**
**         Port data register          : GPIOF_DR  [E251]
**         Port control register       : GPIOF_DDR [E252]
**         Port function register      : GPIOF_PER [E253]
**
**         Optimization for            : speed
**     Contents    :
**         SetDir - void Bit2_SetDir(bool Dir);
**         GetVal - bool Bit2_GetVal(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Bit2. */

#include "Bit2.h"
/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


/*
** ===================================================================
**     Method      :  Bit2_GetVal (component BitIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pin and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)

** ===================================================================
*/
/*
bool Bit2_GetVal(void)

**  This method is implemented as a macro. See Bit2.h file.  **

*/

/*
** ===================================================================
**     Method      :  Bit2_SetDir (component BitIO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bit2_SetDir(bool Dir)
{
  if (Dir) {                           /* Is given direction output? */
    setReg(GPIOF_DR,(getReg(GPIOF_DR)) & (word)~(word)Bit2_PIN_MASK); /* Restore correct value of output from init. value */
    setRegBits(GPIOF_DDR,Bit2_PIN_MASK); /* Set direction to output */
  }
  else {                               /* Is given direction input? */
    clrRegBits(GPIOF_DDR,Bit2_PIN_MASK); /* Set direction to input */
  }
}

/* END Bit2. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
