#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

void main(void) {  
	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;				//FBUS = FPLL/2.   FBUS = 32MHz, 
	CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		    //FREF=8/(1+1) = 4MHZ		
	CPMUSYNR_VCOFRQ = 0x1;            //FVCO is between 48MHZ and 80MHZ	
	CPMUSYNR_SYNDIV = 0x7;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 64MHZ
	CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
	CPMUOSC_OSCE = 1;					//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;					// clear CMPMU flags
  
	/********************************************/
	/************ PWM INITIALIZATION ************/
	/********************************************/
    
    //1. Select 8 bit (CONxx=0) or 16 bit (CONxx=1) operation.
    PWM0CTL = 0;
    PWM1CTL = 0;
    
    //2. Select the clock source (PWMCLK register).
    PWM0CLK = 0;
    PWM1CLK = 0;
    
    //3. Configure prescaler (PWMPRCLK register).
    PWM0PRCLK = 0x44;
    PWM1PRCLK = 0x44;
    
    //4. Configure duty (PWMDTYx) and period (PWMPERx).
    PWM0PER1 = 255;
    PWM1PER1 = 255;
    PWM1PER3 = 255;
    PWM1PER5 = 255;
    PWM0DTY1 = 0;
    PWM1DTY1 = 0;
    PWM1DTY3 = 0;
    PWM1DTY5 = 0;
    
    //5. Select the PWM polarity (PWMPOL).
    PWM0POL = 0;
    PWM1POL = 0;
    
    //6. Select left aligned (CAEx=0) or center aligned (CAEx=1) output.
    PWM0CAE = 0xFF;
    PWM1CAE = 0xFF;
    
    //7. Enable the needed channels (PWMEx=1).
    PWM0E_PWME1 = 1;
    PWM1E_PWME1 = 1;
    PWM1E_PWME3 = 1;
    PWM1E_PWME5 = 1;
    
    //PWM for green LED
    PWM1DTY3 = 20;
    
    /********************************************/
    /************ EMPTY MAIN LOOP ***************/
    /********************************************/
    for(;;){}
}
