/*
 * ADC.c
 *
 *  Created on: Feb 10, 2012
 *      Author: B40150
 */

#include "ADC.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/
	UINT32 adc0_cmdlist[8] @0x002000;
	UINT16 adc0_results[8] @0x002100;
	
	UINT16 adc_ch1 @0x002100;
	UINT16 adc_ch2 @0x002102;
	UINT16 adc_ch3 @0x002104;
	
	UINT32 u32_aux_address;
	UINT8  u8_index = 0;		//index for CSL and RVL items


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/



/**********************************************************************************************
* Local types
**********************************************************************************************/



/**********************************************************************************************
* Local function prototypes
**********************************************************************************************/



/**********************************************************************************************
* Local variables
**********************************************************************************************/



/**********************************************************************************************
* Local functions
**********************************************************************************************/



/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    ADC_Init   Initializes the ADC Module
* @param    none
* @return   none
*
************************************************************************************************/  


void ADC_Init(void)
{
	  adc0_cmdlist[0] = CMD_SEL(1)+ INTFLG_SEL(1)+ VRH_SEL(1)+ VRL_SEL(1)+ CH_SEL(0x11);   //Channel 1 temp
	  adc0_cmdlist[1] = CMD_SEL(1)+ INTFLG_SEL(2)+ VRH_SEL(1)+ VRL_SEL(1)+ CH_SEL(0x12);   //Channel 2 Volume
	  adc0_cmdlist[2] = CMD_SEL(3)+ INTFLG_SEL(3)+ VRH_SEL(1)+ VRL_SEL(1)+ CH_SEL(0x13);   //Channel 3 clock	
	  
	  //Configure ADC0 control
	  ADC0CTL_0 = 0x0D;	//set dual-access mode, trigger mode
	  ADC0CTL_1 = 0x00;	//single CSL & RVL buffers, Normal access, No Auto-Restart after exit from STOP 
	  ADC0STS = 0x00;		//select CSL 0 and RVL 0
	  ADC0TIM = 0x05;		//48Mhz/8Mhz-1 = 5 => fADCCLK = 8MHz
	  
	  //Configure pointers to ADC0 CSL & RVL
	  //*ADC0CBP__ARR = (byte) &adc0_cmdlist;	//map ADC0 list of commands
	  u32_aux_address = (unsigned long) adc0_cmdlist;
	  ADC0CBP_0 = (unsigned char) (u32_aux_address >> 16);
	  ADC0CBP_1 = (unsigned char) (u32_aux_address >> 8);
	  ADC0CBP_2 = (unsigned char) (u32_aux_address);
	  //*ADC0RBP__ARR = (unsigned long) &adc0_results;	//map ADC0 list of results
	  u32_aux_address = (unsigned long) adc0_results;
	  ADC0RBP_0 = (unsigned char) (u32_aux_address >> 16);
	  ADC0RBP_1 = (unsigned char) (u32_aux_address >> 8);
	  ADC0RBP_2 = (unsigned char) (u32_aux_address);	
	  
	  ADC0FMT = 0x80;				//8-bit resolution, left justified
	  
	  //Start conversion -- ADC0
	  ADC0CTL_0_ADC_EN = 1;	//Enable the ADC
}


UINT16 u16_ADC_Read(UINT8 u8_channel){
		
	  ADC0FLWCTL_RSTA = 1;	//Trigger a Restart event		
	  for(u8_index = 0; u8_index < 3; u8_index++){

	    if(u8_index == ADC0CIDX)
	    {
	      ADC0FLWCTL_TRIG = 1;	//Trigger conversion
	    }
	    while (0x00 == ADC0CONIF)
	    {
	      ; 			//wait until ADC conversion is complete
	    }
	    ADC0CONIF = ADC0CONIF;	//clear conversion interrupt flag
	  }	
	  
	  	   if(u8_channel == 1){return adc_ch1;}
	  else if(u8_channel == 2){return adc_ch2;}
	  else if(u8_channel == 3){return adc_ch3;}	  
	  else{return 0;}
}

