/*
 * ADC.h
 *
 *  Created on: Feb 10, 2012
 *      Author: B40150
 */

#ifndef ADC_H_
#define ADC_H_


/*******************************************************************************
* Includes
********************************************************************************/

#include "derivative.h"


/*******************************************************************************
* Constants
********************************************************************************/
#define CMD_SEL(x)	((unsigned long)((x)&0x03)<<30)
#define INTFLG_SEL(x)	((unsigned long)((x)&0x0F)<<24)
#define VRH_SEL(x)	((unsigned long)((x)&0x01)<<23)
#define VRL_SEL(x)	((unsigned long)((x)&0x01)<<22)
#define CH_SEL(x)	((unsigned long)((x)&0x3F)<<16)
#define SMP(x)		((unsigned long)((x)&0x1F)<<11)




/*******************************************************************************
* Macros
********************************************************************************/





                
/*******************************************************************************
* Types
********************************************************************************/

 void ADC_Init(void);
 UINT16 u16_ADC_Read(UINT8 u8_channel);
/*******************************************************************************
*                                Variables
********************************************************************************/


/*******************************************************************************
* Global Variables
********************************************************************************/


/*******************************************************************************
* Global Functions
********************************************************************************/

/*******************************************************************************
*
* @brief    CPMU_Init  Initializes the CPMU Module
* @param    none
* @return   none
*
********************************************************************************/  




#endif /* ADC_H_ */
