/*
 * CAN_Driver.h
 *
 *  Created on: 01/02/2012
 *      Author: B34981
 */

#ifndef CAN_DRIVER_H_
#define CAN_DRIVER_H_


//Tx_TempStruct.u8Tx_Buffer[0] = 0x3;
//Rx_Struct.u8Rx_Buffer[0] = 0x0;


/*Define Structure Length*/
#define STRUCTURE_LENGTH    3                 

/* Acceptance Code Definitions */
#define MASK_CODE_ALL_ID_HIGH  0xFF
#define MASK_CODE_ALL_ID_LOW   0xFF

#define MASK_CODE_ST_ID        0x0007
#define MASK_CODE_ST_ID_HIGH   ((MASK_CODE_ST_ID&0xFF00)>>8)
#define MASK_CODE_ST_ID_LOW    (MASK_CODE_ST_ID&0xFF)

/* Error Flags Definition */
#define NO_ERR                 0x00
#define ERR_BUFFER_FULL        0x80

/*Transmission Structures*/
typedef struct{
  UINT32 u32Id;
  UINT8  u8Tx_Buffer[2];
  UINT8  u8Length;
  UINT8  u8Prio;
  }CAN_Tx_Struct;

extern CAN_Tx_Struct Tx_Struct[STRUCTURE_LENGTH];
extern CAN_Tx_Struct Tx_TempStruct;

extern UINT8 u8CanSendIndex;

/*Reception Structures*/
typedef struct{
  UINT32 u32Id;
  UINT8  u8Rx_Buffer[8];
  UINT8  u8Length;
  UINT8  u8IdHit;
  }CAN_Rx_Struct;

extern CAN_Rx_Struct Rx_Struct;


/*BUFFER RING*/
/* Error Codes */
#define     OK                  0
#define     NOT_ENOUGH_SPACE    1

/* Extern variables */

volatile extern CAN_Tx_Struct *StartAddress;     
volatile extern CAN_Tx_Struct *EndAddress;     
volatile extern CAN_Tx_Struct *App_CanPointer;         
volatile extern CAN_Tx_Struct *Tx_CanPointer;         
volatile extern UINT8 gu8BufferOverFlow;



void CANPHY_Init(void);
void MSCAN_Init(void);
void CAN_ListenOnly(void);
UINT8 CAN_SendFrame(UINT32 u32ID);
void CAN_ReceivedFrame(void);
void MSCAN_Disable(void);
void CAN_EnterSleep(void);

#endif /* CAN_DRIVER_H_ */
