/*
 * Clock.c
 *
 *  Created on: Feb 7, 2012
 *      Author: B40150
 */

/**************************************************/

#include "Clock.h"

/******************************************************************************
* Local function prototypes
******************************************************************************/

void clock_rti_ticks(void);

/******************************************************************************
* Local functions
******************************************************************************/

static volatile UINT32 u32_clock_ticks = 0x00000000;

interrupt VectorNumber_Vrti void clock_rti_ticks(void)
{
	CPMUIFLG_RTIF=1;
	u32_clock_ticks++;
}

/******************************************************************************
* Global functions
******************************************************************************/


/*******************************************************************************
*
* @brief:  CPMU_Init  
* @param:        
* @return:                          
*
********************************************************************************/  

UINT32 Clock_GetTicks(void)
{  
   
   return u32_clock_ticks; 
}


