/*
 * GPIO.c
 *
 *  Created on: Feb 10, 2012
 *      Author: B34981
 */


#include "GPIO.h"

/******************************************************************************
* Global variables
******************************************************************************/
pt2Func PORTS_callback;


/******************************************************************************
* Local function prototypes
******************************************************************************/
void PORTS_ISR(void);

/******************************************************************************
* Local functions
******************************************************************************/



/*******************************************************************************
*
* @brief    PORTS_ISR(void) - PORTS Interrupt Vector, calls the user defined 
* 				callback
* @param    none
* @return   none
*
********************************************************************************/ 
interrupt VectorNumber_Vports void PORTS_ISR(void)
{ 
	PORTS_callback();
}

/*******************************************************************************
*
* @brief    GPIO_Set_Callback(pt2Func callback) - Set a callback to execute when 
* 				PORTS interrupt executes
* @param    Callback Function
* @return   none
*
********************************************************************************/  
void GPIO_Set_Callback(pt2Func callback){
	PORTS_callback = callback;	
}


/*******************************************************************************
*
* @brief    GPIO_Init  Initializes the General Porpuse Input/Output Module
* @param    none
* @return   none
*
********************************************************************************/  
void GPIO_Init (void)
{
 GPIO_DDR(P, 0, 1);        //Enable LED 0 PWM_BACKLIGHT as output
 GPIO_DDR(P, 1, 1);        //Enable LED 1 PWM_SPEED_RED as output
 GPIO_DDR(P, 2, 1);        //Enable LED 2 PWM_SPEED_WHITE as output
 GPIO_DDR(P, 3, 1);        //Enable LED 3 PWM_RPM_RED as output
 GPIO_DDR(P, 4, 1);        //Enable LED 4 PWM_RPM_WHITE as output
 GPIO_DDR(P, 5, 1);        //Enable LED 5 PWM_TEMP_WHITE as output
 GPIO_DDR(P, 6, 1);        //Enable LED 6 PWM_GAS_WHITE as output
 GPIO_DDR(S, 2, 0);        //Enable Switch 5 as input
 GPIO_DDR(S, 3, 0);        //Enable Switch 4 as input
 GPIO_DDR(S, 4, 0);        //Enable Switch 3 as input
 GPIO_DDR(S, 5, 0);        //Enable Switch 2 as input
 GPIO_DDR(S, 6, 0);        //Enable Switch 1 as input
 GPIO_DDR(S, 7, 0);        //Enable Switch 0 as input
 GPIO_DDR(T, 0, 1);        //Enable LED 0 TT_OVER_TEMP as output
 GPIO_DDR(T, 1, 1);        //Enable LED 1 TT_CHK_ENG as output
 GPIO_DDR(T, 2, 1);        //Enable LED 2 as output
 GPIO_DDR(T, 3, 1);        //Enable LED 3 as output
 GPIO_DDR(T, 4, 1);        //Enable LED 4 as output
 GPIO_DDR(T, 5, 1);        //Enable LED 5 as output
 GPIO_DDR(T, 6, 1);        //Enable LED 6 as output
 GPIO_DDR(T, 7, 1);        //Enable LED 7 as output
 GPIO_DDR(C, 0, 1);        //Enable LED 0 as output
 GPIO_DDR(C, 1, 1);        //Enable LED 1 as output
 GPIO_DDR(C, 2, 1);        //Enable LED 2 as output
 GPIO_DDR(C, 3, 1);        //Enable LED 3 as output
 GPIO_PPS(S, 2, 1);		   //Switch Sw 5 Pulldown device selected; rising edge selected
 GPIO_PPS(S, 3, 1);		   //Switch Sw 4 Pulldown device selected; rising edge selected
 GPIO_PPS(S, 4, 1);		   //Switch Sw 3 Pulldown device selected; rising edge selected
 GPIO_PPS(S, 5, 1);		   //Switch Sw 2 Pulldown device selected; rising edge selected
 GPIO_PPS(S, 6, 1);		   //Switch Sw 1 Pulldown device selected; rising edge selected
 GPIO_PPS(S, 7, 1);		   //Switch Sw 0 Pulldown device selected; rising edge selected
 GPIO_PIE(S, 2, 1);		   //Enable Port S Pin 2 Interrupt
 GPIO_PIE(S, 3, 1);		   //Enable Port S Pin 3 Interrupt
 GPIO_PIE(S, 4, 1);		   //Enable Port S Pin 4 Interrupt
 GPIO_PIE(S, 5, 1);		   //Enable Port S Pin 5 Interrupt
 GPIO_PIE(S, 6, 1);		   //Enable Port S Pin 6 Interrupt
 GPIO_PIE(S, 7, 1);		   //Enable Port S Pin 7 Interrupt 
}
    