/*
 * GPIO.h
 *
 *  Created on: Feb 10, 2012
 *      Author: B40150
 */

#ifndef GPIO_H_
#define GPIO_H_


/*******************************************************************************
* Includes
********************************************************************************/

#include "derivative.h"

/*******************************************************************************
* Macros
********************************************************************************/
#define OFF   0
#define ON    1

#define GPIO_DDR(PORT, PIN, DIR)               DDR##PORT##_##DDR##PORT##PIN  = DIR       /* Data Direction Register DDR */
#define GPIO_OVALUE(PORT, PIN, VALUE)          PT##PORT##_##PT##PORT##PIN = VALUE        /* Data Output Value*/
#define GPIO_IVALUE(PORT, PIN)                 PT##PORT##_##PT##PORT##PIN                /* Data Input Value*/
#define GPIO_PPS(PORT, PIN, VALUE)             PPS##PORT##_##PPS##PORT##PIN  = VALUE     /* Polarity Select Register PPS */
#define GPIO_PULL(PORT, PIN, VALUE)            PER##PORT##_PER##PORT##PIN = VALUE        /* Pull up for switch (ch 1AD)*/

#define GPIO_DIEN(PORT, PIN, VALUE)            DIEN##PORT##_##DIEN##PORT##PIN = VALUE    /* Data Direction Register DIEN */
#define GPIO_PIR(PORT, PIN, VALUE)             PIR##PORT##_##PIR##PORT##PIN  = VALUE     /* Input Divider Ratio Selection Register PIR High Voltage Inputs */
#define GPIO_PIE(PORT, PIN, VALUE)             PIE##PORT##_##PIE##PORT##PIN  = VALUE     /* Select Enable Register PIE */
#define GPIO_PIF(PORT, PIN, VALUE)             PIF##PORT##_##PIF##PORT##PIN  = VALUE     /* Port Interrupt Flag Register PIF */


#define GPIO_PTAL_ADCConnection(ADC_CONNECT) PTAL_PTAENL     = ADC_CONNECT                /* Internal ADC Conecction Enable for HVI Port L */
#define GPIO_PTAL_ADCConnectChannel(HVI_CHANNEL) PTAL_PTAL   = HVI_CHANNEL                /* Internal ADC Channel Selection for HVI Port L */

#define Check_Temperature_Led(VALUE)					PTT_PTT0 = VALUE;
#define Check_Engine_Led(VALUE)					PTT_PTT1 = VALUE;
#define Left_Led(VALUE)						    PTT_PTT2 = VALUE;
#define Right_Led(VALUE)						PTT_PTT3 = VALUE;
#define Fuel_Led(VALUE)						    PTT_PTT4 = VALUE;
#define Check_Oil_Led(VALUE)					PTT_PTT5 = VALUE;
#define High_Lights_Led(VALUE)					PTT_PTT6 = VALUE;
#define Low_Lights_Led(VALUE)					PTT_PTT7 = VALUE;
#define	Pointers_Led(VALUE)						{PTC_PTC0 = VALUE; PTC_PTC1 = VALUE; PTC_PTC2 = VALUE; PTC_PTC3 = VALUE;}




                
/*******************************************************************************
* Prototypes
********************************************************************************/

void GPIO_Init(void);
void GPIO_Set_Callback(pt2Func callback);


#endif /* GPIO_H_ */
