/*
 * MCU.c
 *
 *  Created on: Feb 7, 2012
 *      Author: B34981
 */
#include "MCU.h"

/*******************************************************************************
* @brief    PLL_Init - Clock configurations (32 MHz from 8 MHz OSC)
* @param    none
* @return   none
********************************************************************************/ 
void PLL_Init(void)
{	
	
	//WD Disable...
	
	CPMUCLKS_PLLSEL = 0x1;				// FBUS = FPLL/2.   FBUS = 32MHz, 
	CPMUREFDIV_REFDIV = 0x1;		    // FREF = FOSC/(REFDIV+1) = 8/(1+1) = 4MHZ			
	CPMUREFDIV_REFFRQ = 0x1;			// Reference clock between 2MHZ and 6MHZ.	
	CPMUSYNR_SYNDIV = 0x7;				// FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 64MHZ	
	CPMUSYNR_VCOFRQ = 0x1;             	// FVCO is between 48MHZ and 80MHZ	
	CPMUPOSTDIV_POSTDIV = 0x0;			// FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
	CPMUOSC_OSCE = 0x1;					// External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)	
	
	while(!CPMUIFLG_LOCK){}				// Wait for LOCK.      	
		
	CPMUIFLG = 0xFF;					// clear CMPMU int flags - not needed but good practice    
}

/*******************************************************************************
* @brief    RTI_Init - Configure RTI to execute each 1 ms (system tick)
* @param    none
* @return   none
********************************************************************************/ 
void RTI_Init(void){
	CPMUCLKS_RTIOSCSEL = 0x0;          // RTI clock source is IRCCLK.
	CPMURTI_RTDEC = 0x1;               // Decimal based divider value
	CPMURTI_RTR = 0x0;                 // RTI Frequency Divide Rates for RTDEC=1   1x10^3
	CPMUINT_RTIE = 0x1;                // Enable RTI	
}