/*
 * PWM.c
 *
 *  Created on: Feb 16, 2012
 *      Author: B40150
 */

#include "PWM.h"

/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    PWM_Clock_Init   Initializes the PWM Module (7 channels)
* @param    none
* @return   none
*
************************************************************************************************/  

void PWM_Init(void)
{
PWMPOL = 0xFF;   	//Outputs are high at the beginning of the period
PWMCLK = 0xFF;   	//Clock SA or SB is the clock source for PWM channel 7-0
PWMCLKAB = 0xFF; 	//Clock A or SA is the clock source for PWM channel 7-0
PWMPRCLK = 0x77; 	//Clock A = Clock B= Bus clock/128 = 250KHz
PWMSCLA = 1;  		//Clock SA = Clock A / (2 * PWMSCLA) = 125KHz       
PWMSCLB = 1;  		//Clock SB = Clock B / (2 * PWMSCLB) = 125KHz       
PWMPER0 = 250;      //Periodo =  ClockSA/250 = 500Hz
PWMPER1 = 250;
PWMPER2 = 250;
PWMPER3 = 250;
PWMPER4 = 250;      
PWMPER5 = 250;
PWMPER6 = 250;
PWMDTY0=0;          //Duty
PWMDTY1=0;
PWMDTY2=0;
PWMDTY3=0;
PWMDTY4=0;            
PWMDTY5=0;
PWMDTY6=0;
PWME_PWME0=1;     	//Enable PWM0 
PWME_PWME1=1;     	//Enable PWM1
PWME_PWME2=1;     	//Enable PWM2
PWME_PWME3=1;     	//Enable PWM3
PWME_PWME4=1;     	//Enable PWM4
PWME_PWME5=1;     	//Enable PWM5
PWME_PWME6=1;     	//Enable PWM6
}


/***********************************************************************************************
*
* @brief    PWM_SetDuty(UINT8 ch, UINT8 duty) - Set a duty cycle on the determined channel
* @param    ch - channel to modify, duty - counts to program as duty
* @return   none
*
************************************************************************************************/ 

void PWM_SetDuty(UINT8 ch, UINT8 duty)
{
	switch(ch){
	case 0:
		PWMDTY0 = duty;
		break;
	case 1:
		PWMDTY1 = duty;
		break;
	case 2:
		PWMDTY2 = duty;
		break;
	case 3:
		PWMDTY3 = duty;
		break;
	case 4:
		PWMDTY4 = duty;
		break;
	case 5:
		PWMDTY5 = duty;
		break;
	case 6:
		PWMDTY6 = duty;
		break;
	case 7:
		PWMDTY7 = duty;
		break;
	default:
		break;
	}
	
}

