/*
 * RTC.c
 *
 *  Created on: Feb 14, 2012
 *      Author: B40150
 */


#include "RTC.h"

/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    RTC_Init   Initializes the Real Time Counter Module
* @param    none
* @return   none
*
************************************************************************************************/  

void RTC_Init(void)
{
RTCCTL1_COMPE = 1;		//The read/write bit enables the clock compensation mechanism for clock frequency errors.
RTCMOD =  32768;		//Modulo register configuration
RTCCCR_Q = 3;
RTCCCR_CCS = 0;
RTCCTL2_CLKSRC = 1;		// RTCCLK is from OSCCLK_32K
RTCCTL2_RTCPS = 3;      //The input OSCCLK will be divided by (RTCPS+1)
RTCCTL1_RTCEN = 1;		//RTC function is enabled.
}
