/*
 * Stepper.c
 *
 *  Created on: Mar 6, 2012
 *      Author: 
 */



#include "SSD.h"

/******************************************************************************
* External objects
******************************************************************************/
extern MOTOR Motor[4];

/******************************************************************************
* Global variables
******************************************************************************/
UINT8 All_Motors_Stalled = 0;   /* Used to register Motors Condition for SSD logic */

/******************************************************************************
* Local types
******************************************************************************/
typedef struct
{
  UINT8	 u8_SSD_on;           /* Signifies whether SSD should be on or off.        */
  INT8 	 i8_result;           /* Holds result of stall detection function.         */
  INT8 	 i8_SSD_stage;        /* 0==init,1==step/blank,2==intgration,3==evaluation.*/
  INT8 	 i8_clockwise;        /* Indicate motor's relative rotational direction.   */
  INT8 	 i8_step_state;       /* Tracks the 4 possible step states.                */
  UINT16 u16_blanking_count;   /* Specifies blanking duration.                      */
  UINT16 u16_integration_time; /* Specifies integration duration.                   */
  INT16  i16_integrated_value; /* Stores back EMF integrated value.                 */
  INT16  i16_stall_level;      /* Stores the stall threshold level.                 */
  INT16  i16_step_position;    /* Tracks step position.                             */
  INT16  i16_last_stall;       /* Stores the last detected stall value.             */
} TypeSSD;


/******************************************************************************
* Local function prototypes
******************************************************************************/
void SSD0_ISR(void);
void SSD1_ISR(void);
void SSD2_ISR(void);
void SSD3_ISR(void);


/******************************************************************************
* Local variables
******************************************************************************/
TypeSSD SSD[5];

/******************************************************************************
* Global functions
******************************************************************************/

void SSD_Init(void){
UINT8 i = 0;

SSD[4].i8_SSD_stage        = 0;
SSD[4].u16_integration_time = 1000;
SSD[4].i16_stall_level      = 250;
SSD[4].u16_blanking_count   = 150;
SSD[4].i8_step_state       = 0;
SSD[4].i8_clockwise        = 0;			//All RTZ CCW
SSD[4].i16_step_position    = 0;
SSD[4].u8_SSD_on           = 1;	

	for(i = 0 ; i<4; i++){
		SSD[i].i8_SSD_stage        = 0;
		SSD[i].u16_integration_time = 1000;
		SSD[i].i16_stall_level      = 1000;
		SSD[i].u16_blanking_count   = 150;
		SSD[i].i8_step_state       = 0;
		SSD[i].i8_clockwise        = 0;			//All RTZ CCW
		SSD[i].i16_step_position    = 0;
		SSD[i].u8_SSD_on           = 1;	
	}	   
	   //SSD[3].i8_clockwise        = 1;			//Motor 3 RTZ CW
	
	   /*Motor 0*/
	   SSD0FLG_MCZIF = 1;					//Clear modulus counter unterflow flag
	   MDC0CTL_MCZIE = 1;					//Enable modulus counter underflow interrupt
	   MDC0CTL_MODMC = 0; 					//Modulus counter counts down to zero and stops
	   SSD0FLG_AOVIF = 0; 					//Clear Accumulator overflow interrupt flag
	   MDC0CTL_MCEN  = 1;					//Modulus down counter enable
	   MDC0CNT = 31000;							
	
	   /*Motor 1*/
	   SSD1FLG_MCZIF = 1;					//Clear modulus counter unterflow flag
	   MDC1CTL_MCZIE = 1;					//Enable modulus counter underflow interrupt
	   MDC1CTL_MODMC = 0; 					//Modulus counter counts down to zero and stops
	   SSD1FLG_AOVIF = 0; 					//Clear Accumulator overflow interrupt flag
	   MDC1CTL_MCEN  = 1;					//Modulus down counter enable
	   MDC1CNT = 27000;		
	   
	   /*Motor 2*/
	   SSD2FLG_MCZIF = 1;					//Clear modulus counter unterflow flag
	   MDC2CTL_MCZIE = 1;					//Enable modulus counter underflow interrupt
	   MDC2CTL_MODMC = 0; 					//Modulus counter counts down to zero and stops
	   SSD2FLG_AOVIF = 0; 					//Clear Accumulator overflow interrupt flag
	   MDC2CTL_MCEN  = 1;					//Modulus down counter enable
	   MDC2CNT = 13000;		
	   
	   /*Motor 3*/
	   SSD3FLG_MCZIF = 1;					//Clear modulus counter unterflow flag
	   MDC3CTL_MCZIE = 1;					//Enable modulus counter underflow interrupt
	   MDC3CTL_MODMC = 0; 					//Modulus counter counts down to zero and stops
	   SSD3FLG_AOVIF = 0; 					//Clear Accumulator overflow interrupt flag
	   MDC3CTL_MCEN  = 1;					//Modulus down counter enable
	   MDC3CNT = 3000;			   
}


interrupt VectorNumber_Vssd0 void SSD0_ISR(){
	
	   UINT8 M0_Int_Loop_Active = 1;
	   
	   /* Disable SSDx interrupt */
	   MDC0CTL_MCZIE  = 0;

	   while(M0_Int_Loop_Active)
	   {
	     /* STOP SSD */
	     if (SSD[0].u8_SSD_on == 0)
	     {
	       MDC0CTL_MCEN   = 0; /* Disable modulus down-counter.              */
	       RTZ0CTL_ITG    = 0; /* Ensure integration disabled.               */
	       RTZ0CTL_DCOIL  = 0; /* Ensure Dcoils disabled.                    */
	       RTZ0CTL_RCIR   = 0; /* Disable recirculation.                     */
	       SSD0CTL_SDCPU  = 0; /* Power down the SSD sigma delta converter.  */
	       SSD0CTL_RTZE   = 0; /* Disable the SSD module. This also releases */
	                           /* control of the associated port pins.       */
	       SSD[0].i8_SSD_stage = 0; /* Set the stage var to 0.                    */
	       return;             /* Exit SSDx interrupt routine.               */
	     }

	     /* Since this CPU interrupt function may need a few requests in        */
	     /* order to complete the process of performing a step with integration */
	     /* and detecting a stall, the process is divided into stages.          */
	     if (SSD[0].i8_SSD_stage == 0)  
	     {
	       /***************INIT THE SDD MODULE SETTINGS**************/
	       RTZ0CTL_RCIR   = 0;  /* Set recirculation to occur on low-side.                */
	       RTZ0CTL_POL    = 0;  /* Set polarity.                                          */	      
	       MDC0CTL_PRE    = 0;  /* Clear or set the SSD prescaler as desired              */
	       SSD0CTL_ACLKS  = 0;  /* Setup SSD accumulator sample frequency. Recommended    */
	                            /* sample frequencies are between 500Khz and 2Mhz.        */
	       SSD0CTL_RTZE   = 1;  /* Enable SSD module. This also transfers control of the  */
	                            /* associated port pins to the SSD module.                */
	       SSD0CTL_SDCPU  = 1;  /* Power up the SSD sigma delta converter.                */
	       SSD[0].i8_SSD_stage = 1;  /* Since init complete, proceed to the next stage,        */
	                            /* which is blanking/integration of the SSD step.         */
	     }
	     
	     if (SSD[0].i8_SSD_stage == 1)
	     {
	       RTZ0CTL_STEP = SSD[0].i8_step_state; /* Write step state before performing a step. */
	       SSD[0].i8_SSD_stage = 2;             /* Set the next stage.                        */

	       /******************IF BLANKING IS USED********************/
	       /* In some cases, an application may work even when blanking is s*/
	       /* not used. To skip blanking and go straight to integration,   */
	       /* set the variable u16_blanking_count to 0.                        */
	       if (SSD[0].u16_blanking_count > 0)
	       {
	         /*******************BEGIN TAKING A STEP***************************************/
	         SSD0FLG_MCZIF  = 1;  /* Clear the modulus down counter zero flag.            */ 
	         RTZ0CTL_ITG    = 0;  /* Ensure integration disabled before blanking.         */ 
	         MDC0CTL_MCZIE  = 1;  /* Enable zero flag interrupt. When triggered, blanking */ 
	                              /* is complete and the request proceeds to integration. */ 
	         MDC0CTL_MODMC  = 0;  /* Set the modulus mode to 0.                           */ 
	         MDC0CTL_MCEN   = 1;  /* Enable modulus down-counter.                         */ 
	         MDC0CNT        = SSD[0].u16_blanking_count; /* Load the blanking count.            */
	         RTZ0CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                */
	         return;              /* Exit SSDx interrupt routine.                         */
	       }
	     }
	     
	     if (SSD[0].i8_SSD_stage == 2)
	     {  
	       /********************START INTEGRATION***********************/
	       SSD0FLG_MCZIF = 1;  /* Clear modulus down counter zero flag.                    */
	       MDC0CTL_MCZIE = 1;  /* Enable interrupts for zero flag.                         */
	       MDC0CTL_MODMC = 0;  /* Set mode to 0 to count down and stop at zero.            */
	       SSD0FLG_AOVIF = 1;  /* Clear the accumulator overflow flag.                     */
	       MDC0CTL_MCEN  = 1;  /* Enable modulus counter. Count value is loaded next.      */
	       MDC0CNT = SSD[0].u16_integration_time; /* Load the integration count.                 */
	     
	       /* NOTE: If integration is enabled before the modulus counter is set up,       */
	       /* the SSD module may not perform offset cancelation. This increases           */
	       /* the possibility of large offset errors corrupting the integration value.    */
	       /* It is recommended to enable integration AFTER the modulus counter has       */
	       /* been setup and enabled.                                                     */


	       RTZ0CTL_ITG    = 1;  /* Begin integration.                                     */
	       RTZ0CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                  */
	       SSD[0].i8_SSD_stage = 3;  /* Set next stage to evaluate integration result.         */
	       return;              /* Exit interrupt. Integration complete at next request.  */
	     }
	     
	     if (SSD[0].i8_SSD_stage ==3)
	     {
	       /*************READ ITGACC & DISABLE INTEGRATION**************/
	       SSD[0].i16_integrated_value = ITG0ACC;  /* Immediately get the integration result                */
	       RTZ0CTL_ITG   = 0;  /* Accumulator still active. Clear ITG to disable.                     */
	       SSD0FLG_MCZIF = 1;  /* Clear MCZIF flag.                                                   */
	       RTZ0CTL_DCOIL = 0;  /* Disable Dcoil. To leave Dcoil enabled, comment out this instruction.*/
	       MDC0CTL_MCEN  = 0;  /*  Disable modulus down-counter.                                      */

	       /* NOW THAT INTEGRATION HAS COMPLETED, EVALUATE THE RESULT  */
	         /************1ST, CHECK FOR ACCUMULATOR OVERFLOW*************/
	         if (SSD0FLG_AOVIF == 1)
	         {
	            /* If an overlow occurs, the routine must determine what to do.    */
	            /* In this instance, the routine flags a variable for SSDx disable.*/
	            SSD[0].i8_result = 2; /* Overflow detected. Write result variable.      */
	            SSD[0].u8_SSD_on = 0; /* Disable the SSDx module                        */
	         }
	         /*********CHECK IF INTEGRATION VALUE IN STALL RANGE**********/
	         else if (((SSD[0].i16_integrated_value <= SSD[0].i16_stall_level) && (SSD[0].i16_integrated_value >= 0)) ||
	                  ((SSD[0].i16_integrated_value >= (-SSD[0].i16_stall_level)) && (SSD[0].i16_integrated_value <= 0)))
	         {
	            SSD[0].i8_result = 1; /* Write result code to indicate stall detected.          */
	            SSD[0].i16_last_stall = SSD[0].i16_integrated_value; /* Save integration stall value   */
	            /*******SINCE STALL DETECTED, REVERSE MOTOR DIRECTION*******/
	            All_Motors_Stalled |= 1; /* Register Motor Stall to module interface */
	            Motor[0].rtz = 1;
	            
	            /* Disable RTZ */
	            SSD0CTL_RTZE = 0;
	            return;             /* Exit interrupt routine. */
	         }
	         else
	         {
	            SSD[0].i8_result = 0; /* No stall detected. Write result code. */
	            /******************MOVE TO NEXT STEP STATE******************/
	            if (SSD[0].i8_clockwise)
	            {
	               SSD[0].i16_step_position++;
	               SSD[0].i8_step_state++; /* Update to rotate(CCW) through future steps. Direction */
	                                  /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[0].i8_step_state > 3)
	               SSD[0].i8_step_state = 0;
	            }
	            else
	            {
	               SSD[0].i16_step_position--;
	               SSD[0].i8_step_state--;  /* Update to rotate(CCW) through future steps. Direction */
	                                   /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[0].i8_step_state < 0)
	               {
	                  SSD[0].i8_step_state = 3;
	               }
	            }
	            SSD[0].i8_SSD_stage = 1; /* Set stage for blanking/intgrtn. Routine does not exit.*/
	         }
	      }
	      else
	      {
	         SSD[0].u8_SSD_on = 0; /* Stage was an unexpected value, flag SSDx for disable. */
	      }
	   }		
}


interrupt VectorNumber_Vssd1 void SSD1_ISR(){
	
	   UINT8 M1_Int_Loop_Active = 1;
	   
	   /* Disable SSDx interrupt */
	   MDC1CTL_MCZIE  = 0;

	   while(M1_Int_Loop_Active)
	   {
	     /* STOP SSD */
	     if (SSD[1].u8_SSD_on == 0)
	     {
	       MDC1CTL_MCEN   = 0; /* Disable modulus down-counter.              */
	       RTZ1CTL_ITG    = 0; /* Ensure integration disabled.               */
	       RTZ1CTL_DCOIL  = 0; /* Ensure Dcoils disabled.                    */
	       RTZ1CTL_RCIR   = 0; /* Disable recirculation.                     */
	       SSD1CTL_SDCPU  = 0; /* Power down the SSD sigma delta converter.  */
	       SSD1CTL_RTZE   = 0; /* Disable the SSD module. This also releases */
	                           /* control of the associated port pins.       */
	       SSD[1].i8_SSD_stage = 0; /* Set the stage var to 0.                    */
	       return;             /* Exit SSDx interrupt routine.               */
	     }

	     /* Since this CPU interrupt function may need a few requests in        */
	     /* order to complete the process of performing a step with integration */
	     /* and detecting a stall, the process is divided into stages.          */
	     if (SSD[1].i8_SSD_stage == 0)  
	     {
	       /***************INIT THE SDD MODULE SETTINGS**************/
	       RTZ1CTL_RCIR   = 0;  /* Set recirculation to occur on low-side.                */
	       RTZ1CTL_POL    = 0;  /* Set polarity.                                          */	      
	       MDC1CTL_PRE    = 0;  /* Clear or set the SSD prescaler as desired              */
	       SSD1CTL_ACLKS  = 0;  /* Setup SSD accumulator sample frequency. Recommended    */
	                            /* sample frequencies are between 500Khz and 2Mhz.        */
	       SSD1CTL_RTZE   = 1;  /* Enable SSD module. This also transfers control of the  */
	                            /* associated port pins to the SSD module.                */
	       SSD1CTL_SDCPU  = 1;  /* Power up the SSD sigma delta converter.                */
	       SSD[1].i8_SSD_stage = 1;  /* Since init complete, proceed to the next stage,        */
	                            /* which is blanking/integration of the SSD step.         */
	     }
	     
	     if (SSD[1].i8_SSD_stage == 1)
	     {
	       RTZ1CTL_STEP = SSD[1].i8_step_state; /* Write step state before performing a step. */
	       SSD[1].i8_SSD_stage = 2;             /* Set the next stage.                        */

	       /******************IF BLANKING IS USED********************/
	       /* In some cases, an application may work even when blanking is s*/
	       /* not used. To skip blanking and go straight to integration,   */
	       /* set the variable u16_blanking_count to 0.                        */
	       if (SSD[1].u16_blanking_count > 0)
	       {
	         /*******************BEGIN TAKING A STEP***************************************/
	         SSD1FLG_MCZIF  = 1;  /* Clear the modulus down counter zero flag.            */ 
	         RTZ1CTL_ITG    = 0;  /* Ensure integration disabled before blanking.         */ 
	         MDC1CTL_MCZIE  = 1;  /* Enable zero flag interrupt. When triggered, blanking */ 
	                              /* is complete and the request proceeds to integration. */ 
	         MDC1CTL_MODMC  = 0;  /* Set the modulus mode to 0.                           */ 
	         MDC1CTL_MCEN   = 1;  /* Enable modulus down-counter.                         */ 
	         MDC1CNT        = SSD[1].u16_blanking_count; /* Load the blanking count.            */
	         RTZ1CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                */
	         return;              /* Exit SSDx interrupt routine.                         */
	       }
	     }
	     
	     if (SSD[1].i8_SSD_stage == 2)
	     {  
	       /********************START INTEGRATION***********************/
	       SSD1FLG_MCZIF = 1;  /* Clear modulus down counter zero flag.                    */
	       MDC1CTL_MCZIE = 1;  /* Enable interrupts for zero flag.                         */
	       MDC1CTL_MODMC = 0;  /* Set mode to 0 to count down and stop at zero.            */
	       SSD1FLG_AOVIF = 1;  /* Clear the accumulator overflow flag.                     */
	       MDC1CTL_MCEN  = 1;  /* Enable modulus counter. Count value is loaded next.      */
	       MDC1CNT = SSD[1].u16_integration_time; /* Load the integration count.                 */
	     
	       /* NOTE: If integration is enabled before the modulus counter is set up,       */
	       /* the SSD module may not perform offset cancelation. This increases           */
	       /* the possibility of large offset errors corrupting the integration value.    */
	       /* It is recommended to enable integration AFTER the modulus counter has       */
	       /* been setup and enabled.                                                     */


	       RTZ1CTL_ITG    = 1;  /* Begin integration.                                     */
	       RTZ1CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                  */
	       SSD[1].i8_SSD_stage = 3;  /* Set next stage to evaluate integration result.         */
	       return;              /* Exit interrupt. Integration complete at next request.  */
	     }
	     
	     if (SSD[1].i8_SSD_stage ==3)
	     {
	       /*************READ ITGACC & DISABLE INTEGRATION**************/
	       SSD[1].i16_integrated_value = ITG1ACC;  /* Immediately get the integration result                */
	       RTZ1CTL_ITG   = 0;  /* Accumulator still active. Clear ITG to disable.                     */
	       SSD1FLG_MCZIF = 1;  /* Clear MCZIF flag.                                                   */
	       RTZ1CTL_DCOIL = 0;  /* Disable Dcoil. To leave Dcoil enabled, comment out this instruction.*/
	       MDC1CTL_MCEN  = 0;  /*  Disable modulus down-counter.                                      */

	       /* NOW THAT INTEGRATION HAS COMPLETED, EVALUATE THE RESULT  */
	         /************1ST, CHECK FOR ACCUMULATOR OVERFLOW*************/
	         if (SSD1FLG_AOVIF == 1)
	         {
	            /* If an overlow occurs, the routine must determine what to do.    */
	            /* In this instance, the routine flags a variable for SSDx disable.*/
	            SSD[1].i8_result = 2; /* Overflow detected. Write result variable.      */
	            SSD[1].u8_SSD_on = 0; /* Disable the SSDx module                        */
	         }
	         /*********CHECK IF INTEGRATION VALUE IN STALL RANGE**********/
	         else if (((SSD[1].i16_integrated_value <= SSD[1].i16_stall_level) && (SSD[1].i16_integrated_value >= 0)) ||
	                  ((SSD[1].i16_integrated_value >= (-SSD[1].i16_stall_level)) && (SSD[1].i16_integrated_value <= 0)))
	         {
	            SSD[1].i8_result = 1; /* Write result code to indicate stall detected.          */
	            SSD[1].i16_last_stall = SSD[1].i16_integrated_value; /* Save integration stall value   */
	            /*******SINCE STALL DETECTED, REVERSE MOTOR DIRECTION*******/
	            All_Motors_Stalled |= 2; /* Register Motor Stall to module interface */
	            Motor[1].rtz = 1;
	            
	            /* Disable RTZ */
	            SSD1CTL_RTZE = 0;
	            return;             /* Exit interrupt routine. */
	         }
	         else
	         {
	            SSD[1].i8_result = 0; /* No stall detected. Write result code. */
	            /******************MOVE TO NEXT STEP STATE******************/
	            if (SSD[1].i8_clockwise)
	            {
	               SSD[1].i16_step_position++;
	               SSD[1].i8_step_state++; /* Update to rotate(CCW) through future steps. Direction */
	                                  /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[1].i8_step_state > 3)
	               SSD[1].i8_step_state = 0;
	            }
	            else
	            {
	               SSD[1].i16_step_position--;
	               SSD[1].i8_step_state--;  /* Update to rotate(CCW) through future steps. Direction */
	                                   /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[1].i8_step_state < 0)
	               {
	                  SSD[1].i8_step_state = 3;
	               }
	            }
	            SSD[1].i8_SSD_stage = 1; /* Set stage for blanking/intgrtn. Routine does not exit.*/
	         }
	      }
	      else
	      {
	         SSD[1].u8_SSD_on = 0; /* Stage was an unexpected value, flag SSDx for disable. */
	      }
	   }		
}


interrupt VectorNumber_Vssd2 void SSD2_ISR(){
	
	   UINT8 M2_Int_Loop_Active = 1;
	   
	   /* Disable SSDx interrupt */
	   MDC2CTL_MCZIE  = 0;

	   while(M2_Int_Loop_Active)
	   {
	     /* STOP SSD */
	     if (SSD[2].u8_SSD_on == 0)
	     {
	       MDC2CTL_MCEN   = 0; /* Disable modulus down-counter.              */
	       RTZ2CTL_ITG    = 0; /* Ensure integration disabled.               */
	       RTZ2CTL_DCOIL  = 0; /* Ensure Dcoils disabled.                    */
	       RTZ2CTL_RCIR   = 0; /* Disable recirculation.                     */
	       SSD2CTL_SDCPU  = 0; /* Power down the SSD sigma delta converter.  */
	       SSD2CTL_RTZE   = 0; /* Disable the SSD module. This also releases */
	                           /* control of the associated port pins.       */
	       SSD[2].i8_SSD_stage = 0; /* Set the stage var to 0.                    */
	       return;             /* Exit SSDx interrupt routine.               */
	     }

	     /* Since this CPU interrupt function may need a few requests in        */
	     /* order to complete the process of performing a step with integration */
	     /* and detecting a stall, the process is divided into stages.          */
	     if (SSD[2].i8_SSD_stage == 0)  
	     {
	       /***************INIT THE SDD MODULE SETTINGS**************/
	       RTZ2CTL_RCIR   = 0;  /* Set recirculation to occur on low-side.                */
	       RTZ2CTL_POL    = 0;  /* Set polarity.                                          */	      
	       MDC2CTL_PRE    = 0;  /* Clear or set the SSD prescaler as desired              */
	       SSD2CTL_ACLKS  = 0;  /* Setup SSD accumulator sample frequency. Recommended    */
	                            /* sample frequencies are between 500Khz and 2Mhz.        */
	       SSD2CTL_RTZE   = 1;  /* Enable SSD module. This also transfers control of the  */
	                            /* associated port pins to the SSD module.                */
	       SSD2CTL_SDCPU  = 1;  /* Power up the SSD sigma delta converter.                */
	       SSD[2].i8_SSD_stage = 1;  /* Since init complete, proceed to the next stage,        */
	                            /* which is blanking/integration of the SSD step.         */
	     }
	     
	     if (SSD[2].i8_SSD_stage == 1)
	     {
	       RTZ2CTL_STEP = SSD[2].i8_step_state; /* Write step state before performing a step. */
	       SSD[2].i8_SSD_stage = 2;             /* Set the next stage.                        */

	       /******************IF BLANKING IS USED********************/
	       /* In some cases, an application may work even when blanking is s*/
	       /* not used. To skip blanking and go straight to integration,   */
	       /* set the variable u16_blanking_count to 0.                        */
	       if (SSD[2].u16_blanking_count > 0)
	       {
	         /*******************BEGIN TAKING A STEP***************************************/
	         SSD2FLG_MCZIF  = 1;  /* Clear the modulus down counter zero flag.            */ 
	         RTZ2CTL_ITG    = 0;  /* Ensure integration disabled before blanking.         */ 
	         MDC2CTL_MCZIE  = 1;  /* Enable zero flag interrupt. When triggered, blanking */ 
	                              /* is complete and the request proceeds to integration. */ 
	         MDC2CTL_MODMC  = 0;  /* Set the modulus mode to 0.                           */ 
	         MDC2CTL_MCEN   = 1;  /* Enable modulus down-counter.                         */ 
	         MDC2CNT        = SSD[2].u16_blanking_count; /* Load the blanking count.            */
	         RTZ2CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                */
	         return;              /* Exit SSDx interrupt routine.                         */
	       }
	     }
	     
	     if (SSD[2].i8_SSD_stage == 2)
	     {  
	       /********************START INTEGRATION***********************/
	       SSD2FLG_MCZIF = 1;  /* Clear modulus down counter zero flag.                    */
	       MDC2CTL_MCZIE = 1;  /* Enable interrupts for zero flag.                         */
	       MDC2CTL_MODMC = 0;  /* Set mode to 0 to count down and stop at zero.            */
	       SSD2FLG_AOVIF = 1;  /* Clear the accumulator overflow flag.                     */
	       MDC2CTL_MCEN  = 1;  /* Enable modulus counter. Count value is loaded next.      */
	       MDC2CNT = SSD[2].u16_integration_time; /* Load the integration count.                 */
	     
	       /* NOTE: If integration is enabled before the modulus counter is set up,       */
	       /* the SSD module may not perform offset cancelation. This increases           */
	       /* the possibility of large offset errors corrupting the integration value.    */
	       /* It is recommended to enable integration AFTER the modulus counter has       */
	       /* been setup and enabled.                                                     */


	       RTZ2CTL_ITG    = 1;  /* Begin integration.                                     */
	       RTZ2CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                  */
	       SSD[2].i8_SSD_stage = 3;  /* Set next stage to evaluate integration result.         */
	       return;              /* Exit interrupt. Integration complete at next request.  */
	     }
	     
	     if (SSD[2].i8_SSD_stage ==3)
	     {
	       /*************READ ITGACC & DISABLE INTEGRATION**************/
	       SSD[2].i16_integrated_value = ITG2ACC;  /* Immediately get the integration result                */
	       RTZ2CTL_ITG   = 0;  /* Accumulator still active. Clear ITG to disable.                     */
	       SSD2FLG_MCZIF = 1;  /* Clear MCZIF flag.                                                   */
	       RTZ2CTL_DCOIL = 0;  /* Disable Dcoil. To leave Dcoil enabled, comment out this instruction.*/
	       MDC2CTL_MCEN  = 0;  /*  Disable modulus down-counter.                                      */

	       /* NOW THAT INTEGRATION HAS COMPLETED, EVALUATE THE RESULT  */
	         /************1ST, CHECK FOR ACCUMULATOR OVERFLOW*************/
	         if (SSD2FLG_AOVIF == 1)
	         {
	            /* If an overlow occurs, the routine must determine what to do.    */
	            /* In this instance, the routine flags a variable for SSDx disable.*/
	            SSD[2].i8_result = 2; /* Overflow detected. Write result variable.      */
	            SSD[2].u8_SSD_on = 0; /* Disable the SSDx module                        */
	         }
	         /*********CHECK IF INTEGRATION VALUE IN STALL RANGE**********/
	         else if (((SSD[2].i16_integrated_value <= SSD[2].i16_stall_level) && (SSD[2].i16_integrated_value >= 0)) ||
	                  ((SSD[2].i16_integrated_value >= (-SSD[2].i16_stall_level)) && (SSD[2].i16_integrated_value <= 0)))
	         {
	            SSD[2].i8_result = 1; /* Write result code to indicate stall detected.          */
	            SSD[2].i16_last_stall = SSD[2].i16_integrated_value; /* Save integration stall value   */
	            /*******SINCE STALL DETECTED, REVERSE MOTOR DIRECTION*******/
	            All_Motors_Stalled |= 4; /* Register Motor Stall to module interface */
	            Motor[2].rtz = 1;
	            
	            /* Disable RTZ */
	            SSD2CTL_RTZE = 0;
	            return;             /* Exit interrupt routine. */
	         }
	         else
	         {
	            SSD[2].i8_result = 0; /* No stall detected. Write result code. */
	            /******************MOVE TO NEXT STEP STATE******************/
	            if (SSD[2].i8_clockwise)
	            {
	               SSD[2].i16_step_position++;
	               SSD[2].i8_step_state++; /* Update to rotate(CCW) through future steps. Direction */
	                                  /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[2].i8_step_state > 3)
	               SSD[2].i8_step_state = 0;
	            }
	            else
	            {
	               SSD[2].i16_step_position--;
	               SSD[2].i8_step_state--;  /* Update to rotate(CCW) through future steps. Direction */
	                                   /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[2].i8_step_state < 0)
	               {
	                  SSD[2].i8_step_state = 3;
	               }
	            }
	            SSD[2].i8_SSD_stage = 1; /* Set stage for blanking/intgrtn. Routine does not exit.*/
	         }
	      }
	      else
	      {
	         SSD[2].u8_SSD_on = 0; /* Stage was an unexpected value, flag SSDx for disable. */
	      }
	   }		
}


interrupt VectorNumber_Vssd3 void SSD3_ISR(){
	
	   UINT8 M3_Int_Loop_Active = 1;
	   
	   /* Disable SSDx interrupt */
	   MDC3CTL_MCZIE  = 0;

	   while(M3_Int_Loop_Active)
	   {
	     /* STOP SSD */
	     if (SSD[3].u8_SSD_on == 0)
	     {
	       MDC3CTL_MCEN   = 0; /* Disable modulus down-counter.              */
	       RTZ3CTL_ITG    = 0; /* Ensure integration disabled.               */
	       RTZ3CTL_DCOIL  = 0; /* Ensure Dcoils disabled.                    */
	       RTZ3CTL_RCIR   = 0; /* Disable recirculation.                     */
	       SSD3CTL_SDCPU  = 0; /* Power down the SSD sigma delta converter.  */
	       SSD3CTL_RTZE   = 0; /* Disable the SSD module. This also releases */
	                           /* control of the associated port pins.       */
	       SSD[3].i8_SSD_stage = 0; /* Set the stage var to 0.                    */
	       return;             /* Exit SSDx interrupt routine.               */
	     }

	     /* Since this CPU interrupt function may need a few requests in        */
	     /* order to complete the process of performing a step with integration */
	     /* and detecting a stall, the process is divided into stages.          */
	     if (SSD[3].i8_SSD_stage == 0)  
	     {
	       /***************INIT THE SDD MODULE SETTINGS**************/
	       RTZ3CTL_RCIR   = 0;  /* Set recirculation to occur on low-side.                */
	       RTZ3CTL_POL    = 0;  /* Set polarity.                                          */	      
	       MDC3CTL_PRE    = 0;  /* Clear or set the SSD prescaler as desired              */
	       SSD3CTL_ACLKS  = 0;  /* Setup SSD accumulator sample frequency. Recommended    */
	                            /* sample frequencies are between 500Khz and 2Mhz.        */
	       SSD3CTL_RTZE   = 1;  /* Enable SSD module. This also transfers control of the  */
	                            /* associated port pins to the SSD module.                */
	       SSD3CTL_SDCPU  = 1;  /* Power up the SSD sigma delta converter.                */
	       SSD[3].i8_SSD_stage = 1;  /* Since init complete, proceed to the next stage,        */
	                            /* which is blanking/integration of the SSD step.         */
	     }
	     
	     if (SSD[3].i8_SSD_stage == 1)
	     {
	       RTZ3CTL_STEP = SSD[3].i8_step_state; /* Write step state before performing a step. */
	       SSD[3].i8_SSD_stage = 2;             /* Set the next stage.                        */

	       /******************IF BLANKING IS USED********************/
	       /* In some cases, an application may work even when blanking is s*/
	       /* not used. To skip blanking and go straight to integration,   */
	       /* set the variable u16_blanking_count to 0.                        */
	       if (SSD[3].u16_blanking_count > 0)
	       {
	         /*******************BEGIN TAKING A STEP***************************************/
	         SSD3FLG_MCZIF  = 1;  /* Clear the modulus down counter zero flag.            */ 
	         RTZ3CTL_ITG    = 0;  /* Ensure integration disabled before blanking.         */ 
	         MDC3CTL_MCZIE  = 1;  /* Enable zero flag interrupt. When triggered, blanking */ 
	                              /* is complete and the request proceeds to integration. */ 
	         MDC3CTL_MODMC  = 0;  /* Set the modulus mode to 0.                           */ 
	         MDC3CTL_MCEN   = 1;  /* Enable modulus down-counter.                         */ 
	         MDC3CNT        = SSD[3].u16_blanking_count; /* Load the blanking count.            */
	         RTZ3CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                */
	         return;              /* Exit SSDx interrupt routine.                         */
	       }
	     }
	     
	     if (SSD[3].i8_SSD_stage == 2)
	     {  
	       /********************START INTEGRATION***********************/
	       SSD3FLG_MCZIF = 1;  /* Clear modulus down counter zero flag.                    */
	       MDC3CTL_MCZIE = 1;  /* Enable interrupts for zero flag.                         */
	       MDC3CTL_MODMC = 0;  /* Set mode to 0 to count down and stop at zero.            */
	       SSD3FLG_AOVIF = 1;  /* Clear the accumulator overflow flag.                     */
	       MDC3CTL_MCEN  = 1;  /* Enable modulus counter. Count value is loaded next.      */
	       MDC3CNT = SSD[3].u16_integration_time; /* Load the integration count.                 */
	     
	       /* NOTE: If integration is enabled before the modulus counter is set up,       */
	       /* the SSD module may not perform offset cancelation. This increases           */
	       /* the possibility of large offset errors corrupting the integration value.    */
	       /* It is recommended to enable integration AFTER the modulus counter has       */
	       /* been setup and enabled.                                                     */


	       RTZ3CTL_ITG    = 1;  /* Begin integration.                                     */
	       RTZ3CTL_DCOIL  = 1;  /* Turn on the SSD channel coil drivers.                  */
	       SSD[3].i8_SSD_stage = 3;  /* Set next stage to evaluate integration result.         */
	       return;              /* Exit interrupt. Integration complete at next request.  */
	     }
	     
	     if (SSD[3].i8_SSD_stage ==3)
	     {
	       /*************READ ITGACC & DISABLE INTEGRATION**************/
	       SSD[3].i16_integrated_value = ITG3ACC;  /* Immediately get the integration result                */
	       RTZ3CTL_ITG   = 0;  /* Accumulator still active. Clear ITG to disable.                     */
	       SSD3FLG_MCZIF = 1;  /* Clear MCZIF flag.                                                   */
	       RTZ3CTL_DCOIL = 0;  /* Disable Dcoil. To leave Dcoil enabled, comment out this instruction.*/
	       MDC3CTL_MCEN  = 0;  /*  Disable modulus down-counter.                                      */

	       /* NOW THAT INTEGRATION HAS COMPLETED, EVALUATE THE RESULT  */
	         /************1ST, CHECK FOR ACCUMULATOR OVERFLOW*************/
	         if (SSD3FLG_AOVIF == 1)
	         {
	            /* If an overlow occurs, the routine must determine what to do.    */
	            /* In this instance, the routine flags a variable for SSDx disable.*/
	            SSD[3].i8_result = 2; /* Overflow detected. Write result variable.      */
	            SSD[3].u8_SSD_on = 0; /* Disable the SSDx module                        */
	         }
	         /*********CHECK IF INTEGRATION VALUE IN STALL RANGE**********/
	         else if (((SSD[3].i16_integrated_value <= SSD[3].i16_stall_level) && (SSD[3].i16_integrated_value >= 0)) ||
	                  ((SSD[3].i16_integrated_value >= (-SSD[3].i16_stall_level)) && (SSD[3].i16_integrated_value <= 0)))
	         {
	            SSD[3].i8_result = 1; /* Write result code to indicate stall detected.          */
	            SSD[3].i16_last_stall = SSD[3].i16_integrated_value; /* Save integration stall value   */
	            /*******SINCE STALL DETECTED, REVERSE MOTOR DIRECTION*******/
	            All_Motors_Stalled |= 8; /* Register Motor Stall to module interface */
	            Motor[3].rtz = 1;
	            
	            /* Disable RTZ */
	            SSD3CTL_RTZE = 0;
	            return;             /* Exit interrupt routine. */
	         }
	         else
	         {
	            SSD[3].i8_result = 0; /* No stall detected. Write result code. */
	            /******************MOVE TO NEXT STEP STATE******************/
	            if (SSD[3].i8_clockwise)
	            {
	               SSD[3].i16_step_position++;
	               SSD[3].i8_step_state++; /* Update to rotate(CCW) through future steps. Direction */
	                                  /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[3].i8_step_state > 3)
	               SSD[3].i8_step_state = 0;
	            }
	            else
	            {
	               SSD[3].i16_step_position--;
	               SSD[3].i8_step_state--;  /* Update to rotate(CCW) through future steps. Direction */
	                                   /* dependent upon MCU pin connections to the motor.      */
	               if (SSD[3].i8_step_state < 0)
	               {
	                  SSD[3].i8_step_state = 3;
	               }
	            }
	            SSD[3].i8_SSD_stage = 1; /* Set stage for blanking/intgrtn. Routine does not exit.*/
	         }
	      }
	      else
	      {
	         SSD[3].u8_SSD_on = 0; /* Stage was an unexpected value, flag SSDx for disable. */
	      }
	   }		
}