/*
 * SSG.c
 *
 *  Created on: Feb 20, 2012
 *      Author: B34981
 */

#include "SSG.h"

/******************************************************************************
* Global variables
******************************************************************************/
UINT16 u16_ssgTone = 0;  
UINT16 u16_ssgAmp = 0;	
UINT16 u16_ssgDur = 0;	
UINT16 u16_ssgClockPrescaler = 0;


/******************************************************************************
* Local function prototypes
******************************************************************************/
void SSG_Config(enum outputMode mode);
void SSG_Auto(enum automaticMode am, UINT16 ampThreshold, UINT16 ampAdj);

/******************************************************************************
* Local functions
******************************************************************************/
void SSG_Auto(enum automaticMode am, UINT16 ampThreshold, UINT16 ampAdj){
	
	SSG0ADC_ADE = 1;					//Enable attack/decay functionality
	
	switch(am){
		case LinearAttack:    	
	    	SSG0ADC_ADM = 0x00;					//Select linear attack/decay
	    	SSG0ADC_ADS = 0;					//Select attack
			break;	
		case LinearDecay:
	    	SSG0ADC_ADM = 0x00;					//Select linear attack/decay
	    	SSG0ADC_ADS = 1;					//Select decay
			break;
		case GongAttack:
	    	SSG0ADC_ADM = 0x01;					//Select gong attack/decay
	    	SSG0ADC_ADS = 0;					//Select attack			
			break;
		case GongDecay:
	    	SSG0ADC_ADM = 0x01;					//Select gong attack/decay
	    	SSG0ADC_ADS = 1;					//Select decay						
			break;
		case ExponentialAttack:
	    	SSG0ADC_ADM = 0x02;					//Select exponential attack/decay
	    	SSG0ADC_ADS = 0;					//Select attack						
			break;
		case ExponentialDecay:
	    	SSG0ADC_ADM = 0x02;					//Select exponential attack/decay
	    	SSG0ADC_ADS = 1;					//Select decay			
			break;	
	}
	
	SSG0AT = ampThreshold;						//Amplitude threshold
	
	
	SSG0AA = ampAdj;							//Amplitude Adjustment for LINEAR attack or decay only
		
}





void SSG_Config(enum outputMode mode)
{
	SSG0CR_SSGE = 1;    			//SSG Enable
	
	if(mode == MixedOutput){
		SSG0CR_OMS = 0;//Output tone and amplitude mixed on SGT pin
		DDRC_DDRC5 = 1;
		PTC_PTC5 = 1;
	}
	else if(mode == SeparateOutput){
		SSG0CR_OMS = 1;					//Output tone only on SGT pin
	}	

	SSG0CR_STP = 0;						//Allow sound to play
	
	SSG0PS = u16_ssgClockPrescaler;		//Clock prescaler
	
	SSG0TONE = u16_ssgTone;				//Tone frequency

	SSG0AMP = u16_ssgAmp;				//Tone amplitude	

	SSG0DUR = u16_ssgDur;						//Duration	
}

/******************************************************************************
* Global functions
******************************************************************************/

/*******************************************************************************
*
* @brief    CPMU_Init  Initializes the CPMU Module
* @param    none
* @return   none
*
********************************************************************************/  
void SSG_Init()
{
	u16_ssgClockPrescaler = 0xFF; 
 	u16_ssgTone = 0x67;							//600Hz output tone  
 	u16_ssgDur = 0xA;
	u16_ssgAmp = u16_ssgClockPrescaler; 			//Start gong attack from 100%
	SSG_Auto(GongDecay, 0x30, 0x0);
	SSG_Config(MixedOutput);	
}

void SSG_PlaySingleTone(){
	SSG0CR_RDR = 1;
	SSG0CR_RDR = 0;
}

void SSG_StartPlay(){
	SSG0CR_RDR = 1;
}

void SSG_StopPlay(){
	SSG0CR_RDR = 0;	
}

