/*
 * Scheduler.c
 *
 *  Created on: Feb 7, 2012
 *      Author: B40150
 */

#include "Scheduler.h"

/*   Task ID						Task Function			Time Task  */
#define SCHEDULER_TASKS_TABLE 											\
TABLE(Task1,						SSG_TonePlay,			5000		)\
TABLE(Task2,						Volume,					25			)\
TABLE(Task3,						MC_Stepper,				50			)\
TABLE(Task4,						Time,					25			)\
TABLE(Task5,						Turn,					250			)\
TABLE(Task6,						Odometer,				200			)\
TABLE(Task7,						Fuel,					100			)\
TABLE(Task8,						Temperature,			100			)\
TABLE(Task9,						LCD_Data,				20			)\
TABLE(Task10,						Illumination,			1			)


#undef TABLE
#define TABLE(a, b, c) a,

/* Enumeration of Tasks IDs */

typedef enum SchedulerTask_Enum_Tag {
	SCHEDULER_TASKS_TABLE
	MAX_NUM_TASKS
}scheduler_tasks_t;

#undef TABLE
#define TABLE(a, b, c) b,

/* Array of pointer to functions */

pt2Func task_table_ptr[MAX_NUM_TASKS] = {SCHEDULER_TASKS_TABLE};

#undef TABLE
#define TABLE(a, b, c) c,

UINT32 task_table_time[MAX_NUM_TASKS] = {SCHEDULER_TASKS_TABLE};

/******************************************************************************
 * Global functions
 ******************************************************************************/

/*******************************************************************************
 *
 * @brief    SCHD_Scheduler
 * @param    none
 * @return   none
 *
 ********************************************************************************/

void Scheduler_Init(void) {
	volatile UINT8 u8_schd_task_idx;
	volatile UINT32 u32_schd_ticks = 0x00000000;
	volatile UINT32 u32_schd_modulus;
	volatile UINT16 u16_schd_active_task;
	volatile UINT16 u16_schd_task_mask;
	volatile UINT32 u32_schd_previous_tick = 0x00000000;

	for (;;) {
		u32_schd_ticks = Clock_GetTicks();
		u16_schd_active_task = 0x0000;

		if (u32_schd_previous_tick != u32_schd_ticks) {
			u32_schd_previous_tick = u32_schd_ticks;
			for (u8_schd_task_idx = 0; u8_schd_task_idx < MAX_NUM_TASKS; u8_schd_task_idx++) {
				u32_schd_modulus = u32_schd_ticks % task_table_time[u8_schd_task_idx];
				u16_schd_task_mask = 0x0000;

				if (0x00000000 == u32_schd_modulus) {
					u16_schd_task_mask = (UINT16) (1 << u8_schd_task_idx);
					u16_schd_active_task |= u16_schd_task_mask;
				}
			}
			if (0x0000 != u16_schd_active_task) {
				for (u8_schd_task_idx = 0; u8_schd_task_idx < MAX_NUM_TASKS; u8_schd_task_idx++) {
					if ((UINT16) (1 << u8_schd_task_idx) & u16_schd_active_task)
						(*task_table_ptr[u8_schd_task_idx])();
				}
			}
		}

	}
}

